% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_all_performance.R
\name{get_all_performance}
\alias{get_all_performance}
\title{Function to evaluate different nan imputation methods}
\usage{
get_all_performance(data, to_impute, regressors)
}
\arguments{
\item{data}{dataframe with rows = observations and columns = quantitative
variables}

\item{to_impute}{string , name of the variables where there are NANs to
impute}

\item{regressors}{vector of string with names of the variables to use to
apply 1st,4th imputation method}
}
\value{
It returns a performance measures dataframe with rows = methods
and columns = methods' performances
}
\description{
The get_all_performance_boot function is designed to evaluate different
methods of imputing missing values into a dataset
}
\details{
The function calculates performance metrics, such as:

- \eqn{ R^2 = [1/N * [({\sum_{i=1}^N(P_i - (\bar{P})(O_i -
(\bar{O})]/\sigma_{P}*\sigma_{O}]^2}},

- \eqn{RMSE= (1/N * ({\sum_{i=1}^N(P_i - O_i)^2)^{1/2}}}

and

- \eqn{MAE = 1/N * {\sum_{i=1}^N|{P_i - O_i}|}}

for each imputation method

Supported Imputation Methods:

1. Linear Regression Imputation (lm_imputation): it uses a linear regression
model to predict and impute missing values

2. Median Imputation (median_imputation): it replaces missing values with the
median of observed values

3. Mean Imputation (mean_imputation): it replaces missing values with the mean
of observed values

4. Hot Deck Imputation (hot_deck_imputation): it replaces missing values with
similar observed values

5. Expectation-Maximization Imputation (EM_imputation): it uses the
Expectation-Maximization algorithm to estimate and impute missing values

It evaluate different methods of imputing missing values and calculate
performance metrics for each method
}
\note{
For the methods Median Imputation and Mean Imputation, it is not
possible to calculate the R^2 value.  This is because the standard deviation
is zero based on the following R^2 formula:

\eqn{ R^2 = [1/N * [({\sum_{i=1}^N(P_i - (\bar{P})(O_i -
(\bar{O})]/\sigma_{P}*\sigma_{O}]^2}}

where:

- \eqn{N} is the number of imputations,

- \eqn{O_i} are the observed data point,

- \eqn{P_i} are the imputed data point,

- \eqn{\bar{O}} are the average of the observed data,

- \eqn{\bar{P}} are the average of the imputed data,

- \eqn{\sigma_{P}} are the standard deviation of the imputed data,

- \eqn{\sigma_{O}} are the standard deviation of the observed data
}
\examples{

data("airquality")
regressors<-colnames(airquality[,c(3,4)])
suppressWarnings(get_all_performance(data =airquality,"Ozone",regressors = regressors))

}
\references{
OECD/European Union/EC-JRC (2008), Handbook on Constructing
Composite Indicators: Methodology and User Guide, OECD Publishing, Paris,
<https://doi.org/10.1787/9789264043466-en>
}
\keyword{imputation}
\keyword{missing}
\keyword{value}
