% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{annotate}
\alias{annotate}
\title{Annotate one set of intervals with the names of those which intersect with the other}
\usage{
annotate(x, annotation)
}
\arguments{
\item{x}{Integer matrix of two columns, the first column giving the (inclusive) start points of intervals and the second column giving the corresponding (exclusive) end points, or, an integer vector specifying the location of points.}

\item{annotation}{Matrix specifying intervals or vector specifying points with which to annotate \code{x}.}
}
\value{
List of vectors of indices of overlapping intervals/points.
}
\description{
Create a list of vectors of indices/names of intervals/points in \code{annotation} (if \code{annotation} is a two-column matrix/vector respectively) which intersect with each interval/point in \code{x} (if \code{x} is a two-column matrix/vector respectively).
}
\examples{
annotate(rbind(A=c(1, 100), B=c(50, 100)), rbind(a=c(1, 2), b=c(49, 51), c=c(50, 200)))
annotate(rbind(A=c(1, 100), B=c(50, 100)), c(a=1, b=49, c=51, d=100))
}
