% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IIWcode.R
\name{lagfn}
\alias{lagfn}
\title{Create lagged versions the variables in data}
\usage{
lagfn(data, lagvars, id, time, lagfirst = NA)
}
\arguments{
\item{data}{The data to be lagged}

\item{lagvars}{The names of the columns in the data to be lagged}

\item{id}{A character indicating which column of the data contains subject identifiers. ids are assumed to be consecutive integers, with the first subject having id 1}

\item{time}{A character indicating which column of the data contains the times at which each of the observations in data was made}

\item{lagfirst}{A vector giving the value of each lagged variable for the first time within each subject. This is helpful if, for example, time is the variable to be lagged and you know that all subjects entered the study at time zero}
}
\value{
The original data frame with lagged variables added on as columns. For example, if the data frame contains a variable named x giving the value of x for each subject i at each visit j, the returned data frame will contain a column named x.lag containing the value of x for subject i at visit j-1. If j is the first visit for subject i, the lagged value is set to NA
}
\description{
Create lagged versions the variables in data
}
\examples{
library(nlme)
library(data.table)
data(Phenobarb)
head(Phenobarb)

data <- lagfn(Phenobarb,"time","Subject","time")
head(data)
}
