% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{read.data}
\alias{read.data}
\alias{read.data.default}
\alias{read.data.data.frame}
\alias{read.data.matrix}
\title{Read geochronology data}
\usage{
read.data(x, ...)

\method{read.data}{default}(x, method = "U-Pb", format = 1, ...)

\method{read.data}{data.frame}(x, method = "U-Pb", format = 1, ...)

\method{read.data}{matrix}(x, method = "U-Pb", format = 1, ...)
}
\arguments{
\item{x}{either a file name (\code{.csv} format) OR a matrix}

\item{...}{optional arguments to the \code{read.csv} function}

\item{method}{one of \code{'U-Pb'}, \code{'Pb-Pb'}, \code{'Ar-Ar'},
\code{'detritals'}, \code{Rb-Sr}, \code{Sm-Nd}, \code{Re-Os},
\code{Th-U}, \code{'U-Th-He'}, \code{'fissiontracks'} or
\code{'other'}}

\item{format}{formatting option, depends on the value of
    \code{method}.

if \code{method='U-Pb'}, then \code{format} is one of either:

\enumerate{
\item{\code{7/5, s[7/5], 6/8, s[6/8], rho}}
\item{\code{8/6, s[8/6], 7/6, s[7/6] (, rho)}}
\item{\code{X=7/6, s[X], Y=7/5, s[Y], Z=6/8, s[Z] (, rho[X,Y]) (, rho[Y,Z])}}
\item{\code{X=7/5, s[X], Y=6/8, s[Y], Z=4/8, rho[X,Y], rho[X,Z], rho[Y,Z]}}
\item{\code{X=8/6, s[X], Y=7/6, s[Y], Z=4/6, rho[X,Y], rho[X,Z], rho[Y,Z]}}
\item{\code{7/5, s[7/5], 6/8, s[6/8], 4/8, s[4/8], 7/6, s[7/6], 4/7, s[4/7], 4/6, s[4/6]}}
}

where optional columns are marked in round brackets

if \code{method='Pb-Pb'}, then \code{format} is one of either:

\enumerate{
\item{\code{6/4, s[6/4], 7/4, s[7/4], rho}}
\item{\code{4/6, s[4/6], 7/6, s[7/6], rho}}
\item{\code{6/4, s[6/4], 7/4, s[7/4], 7/6, s[7/6]}}
}

if \code{method='Ar-Ar'}, then \code{format} is one of either:

\enumerate{
\item{\code{9/6, s[9/6], 0/6, s[0/6], rho (, 39)}}
\item{\code{6/0, s[6/0], 9/0, s[9/0] (, rho) (, 39)}}
\item{\code{9/0, s[9/0], 6/0, s[6/0], 9/6, s[9/6] (, 39)}}
}

if \code{method='K-Ca'}, then \code{format} is one of either:

\enumerate{
\item{\code{K40/Ca44, s[K40/Ca44], Ca40/Ca44, s[Ca40/Ca44], rho}}
\item{\code{K40/Ca44, s[K40/Ca44], Ca40/Ca44,
            s[Ca40/Ca44], K40/Ca40, s[K40/Ca40]}}
}

if \code{method='Rb-Sr'}, then \code{format} is one of either:

\enumerate{
\item{\code{Rb87/Sr86, s[Rb87/Sr86], Sr87/Sr86, s[Sr87/Sr86] (, rho)}}
\item{\code{Rb, s[Rb], Sr, s[Sr], Sr87/Sr86, s[Sr87/Sr86]}}
}

where \code{Rb} and \code{Sr} are in ppm

if \code{method='Sm-Nd'}, then \code{format} is one of either:

\enumerate{
\item{\code{Sm147/Nd144, s[Sm147/Nd144], Nd143/Nd144, s[Nd143/Nd144] (, rho)}}
\item{\code{Sm, s[Sm], Nd, s[Nd], Nd143/Nd144, s[Nd143/Nd144]}}
}

where \code{Sm} and \code{Nd} are in ppm

if \code{method='Re-Os'}, then \code{format} is one of either:

\enumerate{
\item{\code{Re187/Os188, s[Re187/Os188], Os187/Os188, s[Os187/Os188] (, rho)}}
\item{\code{Re, s[Re], Os, s[Os], Os187/Os188, s[Os187/Os188]}}
}

where \code{Re} and \code{Os} are in ppm

if \code{method='Lu-Hf'}, then \code{format} is one of either:

\enumerate{
\item{\code{Lu176/Hf177, s[Lu176/Hf177], Hf176/Hf177, s[Hf176/Hf177] (, rho)}}
\item{\code{Lu, s[Lu], Hf, s[Hf], Hf176/Hf177, s[Hf176/Hf177]}}
}

where \code{Lu} and \code{Hf} are in ppm

if \code{method='Th-U'}, then \code{format} is one of either:

\enumerate{
\item{\code{X=8/2, s[X], Y=4/2, s[Y], Z=0/2, s[Z], rho[X,Y], rho[X,Z], rho[Y,Z]}}
\item{\code{X=2/8, s[X], Y=4/8, s[Y], Z=0/8, s[Z], rho[X,Y], rho[X,Z], rho[Y,Z]}}
}

where all values are activity ratios

if \code{method='fissiontracks'}, then \code{format} is one of
either:

\enumerate{
\item{the External Detector Method (EDM), which requires a
\eqn{\zeta}-calibration constant and its uncertainty, the induced
track density in a dosimeter glass, and a table with the
spontaneous and induced track densities.}

\item{LA-ICP-MS-based fission track data using the
\eqn{\zeta}-calibration method, which requires a 'session
\eqn{\zeta}' and its uncertainty and a table with the number of
spontaneous tracks, the area over which these were counted and one
or more U/Ca- or U-concentration measurements and their analytical
uncertainties.}

\item{LA-ICP-MS-based fission track data using the 'absolute
dating' method, which only requires a table with the the number of
spontaneous tracks, the area over which these were counted and one
or more U/Ca-ratios or U-concentration measurements (in ppm) and
their analytical uncertainties.}  }}
}
\value{
an object of class \code{UPb}, \code{PbPb}, \code{ArAr},
    \code{KCa}, \code{UThHe}, \code{ReOs}, \code{SmNd},
    \code{RbSr}, \code{LuHf}, \code{detritals},
    \code{fissiontracks}, \code{ThU} or \code{other}
}
\description{
Cast a \code{.csv} file or a matrix into one of \code{IsoplotR}'s
data classes
}
\details{
IsoplotR provides the following example input files:

\itemize{
\item{U-Pb: \code{UPb1.csv}, \code{UPb2.csv}, \code{UPb3.csv},
\code{UPb4.csv}, \code{UPb5.csv}, \code{UPb6.csv} }
\item{Pb-Pb: \code{PbPb1.csv}, \code{PbPb2.csv}, \code{PbPb3.csv} }
\item{Ar-Ar: \code{ArAr1.csv}, \code{ArAr2.csv}, \code{ArAr3.csv}}
\item{K-Ca: \code{KCa1.csv}, \code{KCa2.csv}}, 
\item{Re-Os: \code{ReOs1.csv}, \code{ReOs2.csv}}
\item{Sm-Nd: \code{SmNd1.csv}, \code{SmNd2.csv}}
\item{Rb-Sr: \code{RbSr1.csv}, \code{RbSr2.csv}}
\item{Lu-Hf: \code{LuHf1.csv}, \code{LuHf2.csv}}
\item{Th-U: \code{ThU1.csv}, \code{ThU2.csv}, \code{ThU3.csv},
\code{ThU4.csv}}
\item{fissiontracks: \code{FT1.csv}, \code{FT2.csv},
\code{FT3.csv}}
\item{U-Th-He: \code{UThHe.csv}, \code{UThSmHe.csv}}
\item{detritals: \code{DZ.csv}}
\item{other: \code{LudwigMixture.csv}, \code{LudwigMean.csv},
\code{LudwigKDE.csv} \code{LudwigSpectrum.csv}}
}

The contents of these files can be viewed using the
\code{system.file(...)} function. For example, to read the
\code{ArAr1.csv} file:

\code{fname <- system.file('ArAr1.csv',package='IsoplotR')}

\code{ArAr <- read.data(fname,method='Ar-Ar',format=1)}
}
\examples{

f1 <- system.file("UPb1.csv",package="IsoplotR")
file.show(f1) # inspect the contents of 'UPb1.csv'
d1 <- read.data(f1,method="U-Pb",format=1)
concordia(d1)

f2 <- system.file("ArAr1.csv",package="IsoplotR")
d2 <- read.data(f2,method="Ar-Ar",format=1)
agespectrum(d2)

f3 <- system.file("ReOs1.csv",package="IsoplotR")
d3 <- read.data(f3,method="Re-Os",format=1)
isochron(d2)

f4 <- system.file("FT1.csv",package="IsoplotR")
d4 <- read.data(f4,method="fissiontracks",format=1)
radialplot(d4)

f5 <- system.file("UThSmHe.csv",package="IsoplotR")
d5 <- read.data(f5,method="U-Th-He")
helioplot(d5)

f6 <- system.file("ThU2.csv",package="IsoplotR")
d6 <- read.data(f6,method="Th-U",format=2)
evolution(d6)

#  one detrital zircon U-Pb file (detritals.csv)
f7 <- system.file("DZ.csv",package="IsoplotR")
d7 <- read.data(f7,method="detritals")
kde(d7)

#  four 'other' files (LudwigMixture.csv, LudwigSpectrum.csv,
#  LudwigMean.csv, LudwigKDE.csv)
f8 <- system.file("LudwigMixture.csv",package="IsoplotR")
d8 <- read.data(f8,method="other")
radialplot(d8)

}
\seealso{
\code{\link{examples}}, \code{\link{settings}}
}
