\name{isofind}
\alias{isofind}
\alias{print.isorix}
\alias{summary.isorix}

\title{Infer spatial origins}
\description{
This function performs the assignment of organims of unknown origins.}

\usage{
isofind(
  assign.data,
  isoscape,
  calibfit,
  mask=NULL,
  verbose=interactive()
)
}

\arguments{
  \item{assign.data}{A \var{dataframe} containing the assignment data (see note below)}
  \item{isoscape}{The output of the function \code{\link{isoscape}}}
  \item{calibfit}{The output of the function \code{\link{calibfit}}}
  \item{mask}{A \var{SpatialPolygons} of a mask to replace values on all rasters by NA inside polygons (see details)}
  \item{verbose}{A \var{logical} indicating whether information about the progress of the procedure should be displayed or not while the function is running. By default verbose is \var{TRUE} if users use an interactive R session and \var{FALSE} otherwise.}
}

\details{
An assignment is a comparison, for a given organism, of the predicted isotopic value at its location of origin and the predicted isotopic value at each location of the \code{isoscape}. The difference between these two values constitute the statistic of the assingment test. Under the null hypothesis (when the organism is at a location with the same isotopic value than its original location), the test statistics follows a normal distribution with mean zero and a certain variance that stems from both the isoscape model fits and the calibration fit. The function \code{isofind} computes the map of p-value for such assignment test (i.e. the p-values in all locations of the isoscape) for all individual in the dataframe \code{assign.data}. The function also perform a single assignment for the entire group by combining the individual p-value maps using the Fisher's method (Fisher 1925).

A mask can be used so to remove all values falling in the mask. This can be useful for performing for example assignments on lands only and discarded anything falling in large bodies of water (see example).
}


\value{This function returns a \var{list} of class \var{isorix} containing itself three lists (\code{indiv}, \code{group}, and \code{sp.points}) storing all rasters built during assignment and the spatial points for sources and calibration. The \var{list} \code{indiv} contains three stack of rater layers: one storing the value of the test statistic ("stat"), one storing the value of the variance of the test statistic ("var") and one storing the p-value of the test ("pv"). The \var{list} \code{group} contains one rater storing the p-values of the assignment for the group. The \var{list} \code{sp.points} contains two spatial point objects: \code{source.points} and \code{calib.points}. 
}

\note{
See \code{\link{assigndata}} to know which variables are needed to perform the assignment and their names.
}

\seealso{
\code{\link{IsoriX}} for the complete workflow
}


\references{
Fisher, R.A. (1925). Statistical Methods for Research Workers. Oliver and Boyd (Edinburgh). ISBN 0-05-002170-2.
}

\examples{
\dontrun{
## The following example takes some time and will therefore not
## be run unless you type: example(isofind, run.dontrun=TRUE)

data(calibdata)
data(assigndata)
data(elevraster)
data(countries)
data(oceanmask)
data(Europefit)

## prepare the elevation raster
elevationraster <- relevate(
    elevation.raster=elevraster,
    isofit=Europefit)

## build the isoscape
isoscape <- isoscape(
    elevation.raster=elevationraster,
    isofit=Europefit)

## fit the calibration model
calib <- calibfit(
    calib.data=calibdata,
    isofit=Europefit)


## perform the assignment on land and water
assignment <- isofind(
    assign.data=subset(assigndata,
      species=="Myotis_bechsteinii"),
    isoscape=isoscape,
    calibfit=calib)

assignment


## perform the assignment on land only
assignment.dry <- isofind(
    assign.data=subset(assigndata,
      species=="Myotis_bechsteinii"),
    isoscape=isoscape,
    calibfit=calib,
    mask=oceanmask)

## plot the group assignment
plot(assignment, who="group") ## without decoration

plot(assignment.dry, who="group") ## without decoration

plot(assignment.dry, who="group",
  borders=list(borders=countries),
  mask=list(mask=oceanmask))

## plot the assignment for the 4 first individuals
plot(assignment.dry, who=1:4,
  borders=list(borders=countries),
  mask=list(mask=oceanmask),
  sources=list(draw=FALSE),
  calib=  list(draw=FALSE))

## plot the assignment for the individual "Mbe_8"
plot(assignment.dry, who="Mbe_8",
  borders=list(borders=countries),
  mask=list(mask=oceanmask))

}
}


\keyword{models}
\keyword{regression}
