% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrangling_dataset_labels.R
\name{format_labels}
\alias{format_labels}
\title{Format the label in a simpler format}
\usage{
format_labels(raw_labels, verbose = TRUE)
}
\arguments{
\item{raw_labels}{a \code{gh_response} object output from the function
\code{\link[gh]{gh}} which contains all the data and metadata for GitHub
labels.}

\item{verbose}{A logical value indicating whether to print additional
information. Default is \code{TRUE}.}
}
\value{
a list representing labels with simpler structure (with name,
description, colour)
}
\description{
Format the label in a simpler format
}
\examples{

\donttest{
# With labels
raw_labels <- gh::gh(
   repo = "rjdemetra",
   owner = "rjdverse",
   endpoint = "/repos/:owner/:repo/labels",
   .limit = Inf
)
format_labels(raw_labels)
}

}
