% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractQR.R
\encoding{UTF-8}
\name{extract_QR}
\alias{extract_QR}
\title{Extraction of a quality report}
\usage{
extract_QR(matrix_output_file, sep = ";", dec = ",")
}
\arguments{
\item{matrix_output_file}{the csv file containing the diagnostics matrix.}

\item{sep}{the separator used in the csv file (by default, \code{sep = ";"})}

\item{dec}{the decimal separator used in the csv file (by default,
\code{dec = ","})}
}
\value{
a \code{\link{QR_matrix}} object.
}
\description{
To extract a quality report from the csv file containing the diagnostics
matrix.
}
\details{
This function generates a quality report from a csv file containing
diagnostics (usually from the file \emph{demetra_m.csv}).
The \emph{demetra_m.csv} file can be generated by launching the cruncher
(functions \code{\link[rjwsacruncher]{cruncher}} or
\code{\link[rjwsacruncher]{cruncher_and_param}}) with the default export
parameters, having used the default option \code{csv_layout = "vtable"} to
format the output tables of the functions
\code{\link[rjwsacruncher]{cruncher_and_param}} and
\code{\link[rjwsacruncher]{create_param_file}} when creating the parameters
file.

This function returns a \code{\link{QR_matrix}} object, which is a list of 3
objects:
\itemize{
\item \code{modalities}, a \code{data.frame} containing several indicators and
their categorical quality (Good, Uncertain, Bad, Severe).
\item \code{values}, a \code{data.frame} containing the same indicators and the
values that lead to their quality category (i.e.: p-values, statistics,
etc.) as well as additional variables that don't have a modality/quality
(series frequency and arima model).
\item \code{score_formula} that will store the formula used to calculate the
score (when relevant). Its initial value is \code{NULL}.
}
}
\examples{
# Path of matrix demetra_m
demetra_path <- file.path(
    system.file("extdata", package = "JDCruncheR"),
    "WS/ws_ipi/Output/SAProcessing-1",
    "demetra_m.csv"
)

# Extract the quality report from the demetra_m file
QR <- extract_QR(demetra_path)

print(QR)

# Extract the modalities matrix:
QR$modalities
# Or:
QR[["modalities"]]

}
\seealso{
\link[=fr-extract_QR]{Traduction française}

Other QR_matrix functions: 
\code{\link{export_xlsx}()},
\code{\link{export_xlsx.QR_matrix}()},
\code{\link{export_xlsx.mQR_matrix}()},
\code{\link{rbind.QR_matrix}()},
\code{\link{sort}()},
\code{\link{weighted_score}()}
}
\concept{QR_matrix functions}
