/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.toolkit;

import java.awt.Frame;
import java.awt.Point;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.JGRDataFileSaveDialog;
import org.rosuda.JGR.JGRObjectManager;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.robjects.RObject;
import org.rosuda.JGR.toolkit.DataTable;
import org.rosuda.JGR.toolkit.FontTracker;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.ibase.SVarSet;

public class ObjectBrowserTree
extends JTree
implements ActionListener,
KeyListener,
MouseListener,
DragGestureListener,
DragSourceListener,
TreeWillExpandListener {
    private static final long serialVersionUID = 6767151436107674299L;
    private Collection data;
    private JGRObjectManager objmgr;
    private DragSource dragSource;
    private DataTreeModel objModel;
    private DefaultMutableTreeNode root;
    private RObject selectedObject = null;

    public ObjectBrowserTree(JGRObjectManager jGRObjectManager, Collection collection, String string) {
        this.data = collection;
        this.objmgr = jGRObjectManager;
        ToolTipManager.sharedInstance().registerComponent(this);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        ToolTipManager.sharedInstance().setInitialDelay(0);
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        ToolTipManager.sharedInstance().setReshowDelay(0);
        if (FontTracker.current == null) {
            FontTracker.current = new FontTracker();
        }
        FontTracker.current.add(this);
        this.root = new DefaultMutableTreeNode(string);
        this.objModel = new DataTreeModel(this.root);
        this.setModel(this.objModel);
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 1, this);
        this.setToggleClickCount(100);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addTreeWillExpandListener(this);
    }

    private void addNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        RObject rObject = (RObject)defaultMutableTreeNode.getUserObject();
        Iterator iterator = RController.createContent(rObject, this.data).iterator();
        while (iterator.hasNext()) {
            RObject rObject2 = (RObject)iterator.next();
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(rObject2);
            if (!rObject2.isAtomar()) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode());
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
    }

    public void refresh(Collection collection) {
        this.data = collection;
        this.root.removeAllChildren();
        this.objModel = new DataTreeModel(this.root);
        this.setModel(null);
        this.setModel(this.objModel);
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.objmgr.summary != null) {
            this.objmgr.summary.hide();
        }
        if (mouseEvent.isAltDown()) {
            this.objmgr.setWorking(true);
            Point point = mouseEvent.getPoint();
            RObject rObject = (RObject)((DefaultMutableTreeNode)this.getUI().getClosestPathForLocation(this, point.x, point.y).getLastPathComponent()).getUserObject();
            String string = RController.getSummary(rObject);
            if (string != null) {
                this.objmgr.setWorking(false);
                return string;
            }
            return null;
        }
        return null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.startsWith("saveData")) {
            new JGRDataFileSaveDialog((Frame)((Object)this.objmgr), string.substring(9), JGRPrefs.workingDirectory);
        }
    }

    public void saveData() {
        new JGRDataFileSaveDialog((Frame)((Object)this.objmgr), this.selectedObject.getRName(), JGRPrefs.workingDirectory);
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        Point point = dragGestureEvent.getDragOrigin();
        RObject rObject = (RObject)((DefaultMutableTreeNode)this.getUI().getClosestPathForLocation(this, point.x, point.y).getLastPathComponent()).getUserObject();
        StringSelection stringSelection = new StringSelection(rObject.getRName());
        if (stringSelection == null) {
            return;
        }
        this.dragSource.startDrag(dragGestureEvent, DragSource.DefaultCopyDrop, stringSelection, this);
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 8) {
            TreePath[] treePathArray = this.getSelectionPaths();
            for (int i = 0; i < treePathArray.length; ++i) {
                TreePath treePath = treePathArray[i];
                try {
                    if (((DefaultMutableTreeNode)treePath.getLastPathComponent()).getLevel() != 1) continue;
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(1);
                    JGR.timedEval("rm(" + ((RObject)defaultMutableTreeNode.getUserObject()).getRName() + ")");
                    this.objModel.removeNodeFromParent(defaultMutableTreeNode);
                    continue;
                }
                catch (Exception exception) {
                    new ErrorMsg(exception);
                }
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        SVarSet sVarSet;
        Point point = mouseEvent.getPoint();
        RObject rObject = null;
        try {
            rObject = (RObject)((DefaultMutableTreeNode)this.getUI().getClosestPathForLocation(this, point.x, point.y).getLastPathComponent()).getUserObject();
            this.objmgr.savedata.setEnabled(rObject.isEditable());
            this.selectedObject = rObject;
        }
        catch (Exception exception) {
            this.objmgr.savedata.setEnabled(false);
            this.selectedObject = null;
        }
        if (mouseEvent.getClickCount() == 2 && rObject != null && (sVarSet = RController.newSet(rObject)) != null && sVarSet.count() != 0) {
            new DataTable(sVarSet, rObject.getType(), rObject.isEditable());
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.objmgr.summary != null) {
            this.objmgr.summary.hide();
        }
        if (mouseEvent.isPopupTrigger()) {
            this.objmgr.setWorking(true);
            Point point = mouseEvent.getPoint();
            JToolTip jToolTip = new JToolTip();
            RObject rObject = (RObject)((DefaultMutableTreeNode)this.getUI().getClosestPathForLocation(this, point.x, point.y).getLastPathComponent()).getUserObject();
            String string = RController.getSummary(rObject);
            if (string == null) {
                this.objmgr.setWorking(false);
                return;
            }
            jToolTip.setTipText(string);
            SwingUtilities.convertPointToScreen(point, this);
            this.objmgr.summary = PopupFactory.getSharedInstance().getPopup(this, jToolTip, point.x + 20, point.y + 25);
            this.objmgr.summary.show();
            this.objmgr.setWorking(false);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.objmgr.setWorking(true);
            Point point = mouseEvent.getPoint();
            JToolTip jToolTip = new JToolTip();
            RObject rObject = (RObject)((DefaultMutableTreeNode)this.getUI().getClosestPathForLocation(this, point.x, point.y).getLastPathComponent()).getUserObject();
            String string = RController.getSummary(rObject);
            if (string == null) {
                this.objmgr.setWorking(false);
                return;
            }
            jToolTip.setTipText(string);
            SwingUtilities.convertPointToScreen(point, this);
            this.objmgr.summary = PopupFactory.getSharedInstance().getPopup(this, jToolTip, point.x + 20, point.y + 25);
            this.objmgr.summary.show();
            this.objmgr.setWorking(false);
        }
    }

    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        if (!this.hasBeenExpanded(treePath)) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            defaultMutableTreeNode.removeAllChildren();
            this.objmgr.setWorking(true);
            this.addNodes(defaultMutableTreeNode);
            this.objmgr.setWorking(false);
        }
    }

    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
    }

    class DataTreeModel
    extends DefaultTreeModel {
        private static final long serialVersionUID = 7491143716491925921L;
        TreeNode root;

        public DataTreeModel(TreeNode treeNode) {
            super(treeNode);
            this.root = treeNode;
            Iterator iterator = ObjectBrowserTree.this.data.iterator();
            while (iterator.hasNext()) {
                RObject rObject = (RObject)iterator.next();
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(rObject);
                if (!rObject.isAtomar()) {
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode());
                }
                ((DefaultMutableTreeNode)this.root).add(defaultMutableTreeNode);
            }
        }
    }
}

