/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.toolkit;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.ibase.Common;

public class PrefDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 5324021223225690636L;
    private JTabbedPane tabbedPrefs;
    private JPanel DocumentPrefs;
    private JLabel fontLabel;
    private JLabel commentLabel;
    private JCheckBox italicObjects;
    private JCheckBox boldKeywords;
    private JButton strings;
    private JLabel stringsLabel;
    private JButton objects;
    private JLabel objectLabel;
    private JLabel keywordLabel;
    private JButton keyword;
    private JButton numbers;
    private JLabel numberLabel;
    private JComboBox style;
    private JLabel styleLabel;
    private JButton comment;
    private JPanel documentPanel;
    private JButton errors;
    private JLabel sizeLabel;
    private JLabel errorLabel;
    private JButton commands;
    private JLabel commandLabel;
    private JLabel resultsLabel;
    private JButton results;
    private JPanel outputPanel;
    private JComboBox sizeComboBox;
    private JComboBox fontComboBox;
    private final String[] sizes = new String[]{"2", "4", "6", "8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24"};
    private JButton brackets;
    private JLabel bracketLabel;
    private JCheckBox autotab;
    private JButton highlightColor;
    private JCheckBox highlight;
    private JCheckBox monospaced;
    private JCheckBox lineNumbers;
    private JButton reset;
    private JPanel generalPanel;
    private JButton cancel;
    private JButton okay;
    private JButton workingButton;
    private JTextField working;
    private JLabel workingLabel;
    private JCheckBox hidden;
    private JCheckBox helpAgentConsole;
    private JCheckBox helpAgentEditor;
    private JPanel general;
    private JCheckBox emacs;
    private JSpinner helpPages;
    private JLabel maxHelpLabel;
    private JPanel helpPanel;
    private JLabel tabWidthLabel;
    private JSpinner tabwidth;
    private JSeparator sep1;
    private JSeparator sep;
    private JCheckBox savingWorkspace;
    private final String[] styles = new String[]{" ", "JGR", "eclipse", "emacs", "MSVS 2008", "vim", "Xcode"};
    private static Vector plugInPanels;
    private static Vector plugInActionListeners;
    private final Object[][] styleDef = new Object[][]{{new Color(0, 120, 0), new Color(0, 0, 140), Color.red, Color.blue, new Color(50, 0, 140), new Boolean(true), new Boolean(true), new Boolean(true)}, {new Color(3119446), new Color(8323157), new Color(0), new Color(255), new Color(0), new Boolean(true), new Boolean(false), new Boolean(true)}, {new Color(11280416), new Color(10232046), new Color(0), new Color(0xBD8D8B), new Color(0), new Boolean(true), new Boolean(false), new Boolean(false)}, {new Color(32768), new Color(255), new Color(0), new Color(10687765), new Color(0), new Boolean(false), new Boolean(false), new Boolean(false)}, {new Color(255), new Color(11692056), new Color(0xFF0000), new Color(0xFF0000), new Color(0), new Boolean(false), new Boolean(false), new Boolean(false)}, {new Color(32540), new Color(9371733), new Color(2294015), new Color(0xC00000), new Color(0), new Boolean(false), new Boolean(false), new Boolean(false)}};
    private JCheckBox italicComments;
    private static PrefDialog instance;

    private PrefDialog(JFrame jFrame) {
        super(jFrame);
        this.initGUI();
        if (plugInPanels == null || plugInActionListeners == null) {
            plugInPanels = new Vector();
            plugInActionListeners = new Vector();
        } else {
            for (int i = 0; i < plugInPanels.size(); ++i) {
                PJPanel pJPanel = (PJPanel)plugInPanels.get(i);
                this.tabbedPrefs.add(pJPanel);
                pJPanel.reset();
                this.okay.addActionListener((ActionListener)plugInActionListeners.get(i));
                this.cancel.addActionListener((ActionListener)plugInActionListeners.get(i));
                this.reset.addActionListener((ActionListener)plugInActionListeners.get(i));
            }
        }
        this.setFontComboBox();
        this.reset();
    }

    public static PrefDialog showPreferences(JFrame jFrame) {
        if (instance == null) {
            instance = new PrefDialog(jFrame);
        }
        return instance;
    }

    public void dispose() {
        instance = null;
        super.dispose();
    }

    private void initGUI() {
        try {
            this.getContentPane().setLayout(null);
            this.tabbedPrefs = new JTabbedPane();
            this.getContentPane().add(this.tabbedPrefs);
            this.tabbedPrefs.setBounds(0, 12, 560, 400);
            this.DocumentPrefs = new JPanel();
            this.tabbedPrefs.addTab("Style", null, this.DocumentPrefs, null);
            this.DocumentPrefs.setLayout(null);
            this.DocumentPrefs.setPreferredSize(new Dimension(532, 351));
            this.fontLabel = new JLabel();
            this.DocumentPrefs.add(this.fontLabel);
            this.fontLabel.setText("Font:");
            this.fontLabel.setBounds(90, 12, 41, 14);
            DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel();
            this.fontComboBox = new JComboBox();
            this.DocumentPrefs.add(this.fontComboBox);
            this.fontComboBox.setModel(defaultComboBoxModel);
            this.fontComboBox.setBounds(131, 7, 164, 23);
            this.sizeLabel = new JLabel();
            this.DocumentPrefs.add(this.sizeLabel);
            this.sizeLabel.setText("Size:");
            this.sizeLabel.setBounds(307, 12, 38, 14);
            defaultComboBoxModel = new DefaultComboBoxModel<String>(this.sizes);
            this.sizeComboBox = new JComboBox();
            this.DocumentPrefs.add(this.sizeComboBox);
            this.sizeComboBox.setModel(defaultComboBoxModel);
            this.sizeComboBox.setBounds(351, 9, 59, 21);
            this.sizeComboBox.setEditable(true);
            this.outputPanel = new JPanel();
            this.DocumentPrefs.add(this.outputPanel);
            this.outputPanel.setBounds(74, 59, 379, 98);
            this.outputPanel.setBorder(BorderFactory.createTitledBorder("Output Coloring"));
            this.outputPanel.setLayout(null);
            this.results = new JButton();
            this.outputPanel.add(this.results);
            this.results.setBounds(57, 40, 64, 32);
            this.results.setToolTipText("Result Color");
            this.results.addActionListener(this);
            this.resultsLabel = new JLabel();
            this.outputPanel.add(this.resultsLabel);
            this.resultsLabel.setText("Results");
            this.resultsLabel.setBounds(57, 19, 64, 20);
            this.resultsLabel.setHorizontalTextPosition(0);
            this.resultsLabel.setHorizontalAlignment(0);
            this.commandLabel = new JLabel();
            this.outputPanel.add(this.commandLabel);
            this.commandLabel.setText("Commands");
            this.commandLabel.setBounds(150, 19, 80, 20);
            this.commandLabel.setHorizontalAlignment(0);
            this.commands = new JButton();
            this.outputPanel.add(this.commands);
            this.commands.setBounds(158, 40, 64, 32);
            this.commands.addActionListener(this);
            this.errorLabel = new JLabel();
            this.outputPanel.add(this.errorLabel);
            this.errorLabel.setText("Errors");
            this.errorLabel.setBounds(257, 19, 64, 20);
            this.errorLabel.setHorizontalAlignment(0);
            this.errors = new JButton();
            this.outputPanel.add(this.errors);
            this.errors.setBounds(257, 40, 64, 32);
            this.errors.addActionListener(this);
            this.documentPanel = new JPanel();
            this.DocumentPrefs.add(this.documentPanel);
            this.documentPanel.setBounds(6, 169, 530, 182);
            this.documentPanel.setBorder(BorderFactory.createTitledBorder("Documents"));
            this.documentPanel.setLayout(null);
            this.comment = new JButton();
            this.documentPanel.add(this.comment);
            this.comment.setBounds(17, 73, 64, 32);
            this.comment.addActionListener(this);
            this.commentLabel = new JLabel();
            this.documentPanel.add(this.commentLabel);
            this.commentLabel.setText("Comments");
            this.commentLabel.setBounds(12, 53, 74, 20);
            this.commentLabel.setHorizontalAlignment(0);
            this.styleLabel = new JLabel();
            this.documentPanel.add(this.styleLabel);
            this.styleLabel.setText("Style:");
            this.styleLabel.setBounds(61, 19, 49, 14);
            defaultComboBoxModel = new DefaultComboBoxModel<String>(this.styles);
            this.style = new JComboBox();
            this.documentPanel.add(this.style);
            this.style.setModel(defaultComboBoxModel);
            this.style.setBounds(110, 14, 106, 25);
            this.style.addActionListener(this);
            this.numberLabel = new JLabel();
            this.documentPanel.add(this.numberLabel);
            this.numberLabel.setText("Numbers");
            this.numberLabel.setBounds(200, 53, 64, 20);
            this.numberLabel.setHorizontalAlignment(0);
            this.numbers = new JButton();
            this.documentPanel.add(this.numbers);
            this.numbers.setBounds(200, 73, 64, 32);
            this.numbers.addActionListener(this);
            this.keyword = new JButton();
            this.documentPanel.add(this.keyword);
            this.keyword.setBounds(110, 73, 64, 32);
            this.keyword.addActionListener(this);
            this.keywordLabel = new JLabel();
            this.documentPanel.add(this.keywordLabel);
            this.keywordLabel.setText("Key Words");
            this.keywordLabel.setBounds(108, 53, 70, 20);
            this.keywordLabel.setHorizontalAlignment(0);
            this.objectLabel = new JLabel();
            this.documentPanel.add(this.objectLabel);
            this.objectLabel.setText("Objects");
            this.objectLabel.setBounds(110, 116, 64, 20);
            this.objectLabel.setHorizontalAlignment(0);
            this.objects = new JButton();
            this.documentPanel.add(this.objects);
            this.objects.setBounds(110, 136, 64, 32);
            this.objects.addActionListener(this);
            this.stringsLabel = new JLabel();
            this.documentPanel.add(this.stringsLabel);
            this.stringsLabel.setText("Strings");
            this.stringsLabel.setBounds(17, 116, 64, 20);
            this.stringsLabel.setHorizontalAlignment(0);
            this.strings = new JButton();
            this.documentPanel.add(this.strings);
            this.strings.setBounds(17, 136, 64, 32);
            this.strings.addActionListener(this);
            this.boldKeywords = new JCheckBox();
            this.documentPanel.add(this.boldKeywords);
            this.boldKeywords.setText("Bold Key Words");
            this.boldKeywords.setBounds(180, 110, 130, 18);
            this.boldKeywords.addActionListener(this);
            this.italicObjects = new JCheckBox();
            this.documentPanel.add(this.italicObjects);
            this.italicObjects.setText("Italic Objects");
            this.italicObjects.setBounds(180, 135, 122, 18);
            this.italicObjects.addActionListener(this);
            this.italicComments = new JCheckBox();
            this.documentPanel.add(this.italicComments);
            this.italicComments.setText("Italic Comments");
            this.italicComments.setBounds(180, 160, 135, 18);
            this.italicComments.addActionListener(this);
            this.sep = new JSeparator();
            this.documentPanel.add(this.sep);
            this.sep.setBounds(49, 46, 182, 8);
            this.sep1 = new JSeparator();
            this.documentPanel.add(this.sep1);
            this.sep1.setBounds(308, 17, 10, 150);
            this.sep1.setOrientation(1);
            this.tabWidthLabel = new JLabel();
            this.documentPanel.add(this.tabWidthLabel);
            this.tabWidthLabel.setText("Tab Width:");
            this.tabWidthLabel.setBounds(348, 19, 67, 14);
            this.tabwidth = new JSpinner();
            this.documentPanel.add(this.tabwidth);
            this.tabwidth.setBounds(415, 16, 48, 21);
            this.monospaced = new JCheckBox();
            this.DocumentPrefs.add(this.monospaced);
            this.monospaced.setText("Monospaced fonts");
            this.monospaced.setBounds(126, 30, 164, 18);
            this.monospaced.addActionListener(this);
            this.generalPanel = new JPanel();
            this.tabbedPrefs.addTab("General", null, this.generalPanel, null);
            this.generalPanel.setLayout(null);
            this.helpPanel = new JPanel();
            this.generalPanel.add(this.helpPanel);
            this.helpPanel.setBounds(10, 195, 520, 147);
            this.helpPanel.setBorder(BorderFactory.createTitledBorder("Help"));
            this.helpPanel.setLayout(null);
            this.helpPages = new JSpinner();
            this.helpPanel.add(this.helpPages);
            this.helpPages.setBounds(160, 39, 46, 21);
            this.general = new JPanel();
            this.generalPanel.add(this.general);
            this.general.setBounds(10, 15, 520, 180);
            this.general.setBorder(BorderFactory.createTitledBorder("General"));
            this.general.setLayout(null);
            this.hidden = new JCheckBox();
            this.general.add(this.hidden);
            this.hidden.setText("Show Hidden Files");
            this.hidden.setBounds(10, 95, 170, 18);
            this.workingLabel = new JLabel();
            this.general.add(this.workingLabel);
            this.workingLabel.setText("Default Working Directory");
            this.workingLabel.setBounds(12, 40, 180, 14);
            this.working = new JTextField();
            this.general.add(this.working);
            this.working.setBounds(10, 60, 235, 21);
            this.workingButton = new JButton();
            this.general.add(this.workingButton);
            this.workingButton.setText("dir");
            this.workingButton.setBounds(244, 60, 30, 21);
            this.workingButton.addActionListener(this);
            this.emacs = new JCheckBox();
            this.general.add(this.emacs);
            this.emacs.setText("Emacs Bindings (just Mac OS X)");
            this.emacs.setBounds(10, 120, 250, 18);
            this.savingWorkspace = new JCheckBox();
            this.general.add(this.savingWorkspace);
            this.savingWorkspace.setText("Ask \"Saving Workspace\" (if disabled it will not be saved)");
            this.savingWorkspace.setBounds(10, 145, 400, 18);
            this.okay = new JButton();
            this.getContentPane().add(this.okay);
            this.okay.setText("Save All");
            this.okay.setBounds(426, 420, 100, 21);
            this.okay.addActionListener(this);
            this.cancel = new JButton();
            this.getContentPane().add(this.cancel);
            this.cancel.setText("Cancel");
            this.cancel.setBounds(321, 420, 100, 21);
            this.cancel.addActionListener(this);
            this.reset = new JButton();
            this.getContentPane().add(this.reset);
            this.reset.setText("Reset All");
            this.reset.setBounds(216, 420, 100, 21);
            this.reset.addActionListener(this);
            this.lineNumbers = new JCheckBox();
            this.documentPanel.add(this.lineNumbers);
            this.lineNumbers.setText("Display Line Numbers");
            this.lineNumbers.setBounds(348, 41, 170, 18);
            this.highlight = new JCheckBox();
            this.documentPanel.add(this.highlight);
            this.highlight.setText("Highlight Active Line");
            this.highlight.setBounds(348, 89, 170, 18);
            this.highlightColor = new JButton();
            this.documentPanel.add(this.highlightColor);
            this.highlightColor.setBounds(365, 112, 50, 21);
            this.highlightColor.addActionListener(this);
            this.autotab = new JCheckBox();
            this.documentPanel.add(this.autotab);
            this.autotab.setText("Automatic Tabs");
            this.autotab.setBounds(348, 64, 144, 18);
            this.bracketLabel = new JLabel();
            this.documentPanel.add(this.bracketLabel);
            this.bracketLabel.setText("Bracket Matching");
            this.bracketLabel.setBounds(348, 141, 115, 14);
            this.brackets = new JButton();
            this.documentPanel.add(this.brackets);
            this.brackets.setBounds(365, 156, 50, 21);
            this.brackets.addActionListener(this);
            this.helpPages.setValue(new Integer(10));
            this.helpPages.getEditor().setPreferredSize(new Dimension(32, 17));
            this.maxHelpLabel = new JLabel();
            this.helpPanel.add(this.maxHelpLabel);
            this.maxHelpLabel.setText("Maximum Help Pages:");
            this.maxHelpLabel.setBounds(12, 40, 140, 14);
            this.helpAgentConsole = new JCheckBox();
            this.helpPanel.add(this.helpAgentConsole);
            this.helpAgentConsole.setText("Console Help Agent");
            this.helpAgentConsole.setBounds(10, 65, 180, 18);
            this.helpAgentEditor = new JCheckBox();
            this.helpPanel.add(this.helpAgentEditor);
            this.helpAgentEditor.setText("Editor Help Agent");
            this.helpAgentEditor.setBounds(10, 90, 180, 18);
            this.lineNumbers.setEnabled(false);
            this.setTitle("Preferences");
            this.setSize(560, 485);
            if (!Common.isMac()) {
                this.commands.setContentAreaFilled(false);
                this.commands.setOpaque(true);
                this.results.setContentAreaFilled(false);
                this.results.setOpaque(true);
                this.errors.setContentAreaFilled(false);
                this.errors.setOpaque(true);
                this.comment.setContentAreaFilled(false);
                this.comment.setOpaque(true);
                this.numbers.setContentAreaFilled(false);
                this.numbers.setOpaque(true);
                this.objects.setContentAreaFilled(false);
                this.objects.setOpaque(true);
                this.strings.setContentAreaFilled(false);
                this.strings.setOpaque(true);
                this.keyword.setContentAreaFilled(false);
                this.keyword.setOpaque(true);
                this.highlightColor.setContentAreaFilled(false);
                this.highlightColor.setOpaque(true);
                this.brackets.setContentAreaFilled(false);
                this.brackets.setOpaque(true);
            } else {
                this.commands.setText("Color");
                this.results.setText("Color");
                this.errors.setText("Color");
                this.comment.setText("Color");
                this.numbers.setText("Color");
                this.objects.setText("Color");
                this.strings.setText("Color");
                this.keyword.setText("Color");
                this.highlightColor.setText("C");
                this.brackets.setText("C");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setFontComboBox() {
        int n;
        Vector<String> vector = new Vector<String>();
        String string = "";
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        for (n = 0; n < stringArray.length; ++n) {
            string = stringArray[n];
            boolean bl = true;
            int n2 = 0;
            int n3 = 12;
            Font font = new Font(string, n2, n3);
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            int n4 = 0;
            boolean bl2 = false;
            for (int i = 0; i < 128; ++i) {
                if (!Character.isValidCodePoint(i) || Character.isWhitespace(i) || !Character.isLetter(i) && !Character.isDigit(i)) continue;
                char c = (char)i;
                int n5 = fontMetrics.charWidth(c);
                if (bl2) {
                    if (n5 == n4) continue;
                    bl = false;
                    break;
                }
                n4 = n5;
                bl2 = true;
            }
            if (!bl) continue;
            vector.add(string);
        }
        graphics2D.dispose();
        this.fontComboBox.setModel(new DefaultComboBoxModel());
        for (n = 0; n < vector.size(); ++n) {
            this.fontComboBox.addItem(vector.get(n));
        }
    }

    public void setStyle(int n) {
        Object[] objectArray = this.styleDef[n];
        this.setColor(this.comment, (Color)objectArray[0]);
        this.setColor(this.keyword, (Color)objectArray[1]);
        this.setColor(this.numbers, (Color)objectArray[2]);
        this.setColor(this.strings, (Color)objectArray[3]);
        this.setColor(this.objects, (Color)objectArray[4]);
        this.boldKeywords.setSelected((Boolean)objectArray[5]);
        this.italicObjects.setSelected((Boolean)objectArray[6]);
        this.italicComments.setSelected((Boolean)objectArray[6]);
    }

    public void setColor(JButton jButton, Color color) {
        if (!Common.isMac()) {
            jButton.setBackground(color);
        } else {
            jButton.setForeground(color);
        }
    }

    public Color getColor(JButton jButton) {
        if (!Common.isMac()) {
            return jButton.getBackground();
        }
        return jButton.getForeground();
    }

    public void reset() {
        this.setStyle(0);
        this.setColor(this.highlightColor, JGRPrefs.HIGHLIGHTColor);
        this.setColor(this.results, JGRPrefs.RESULTColor);
        this.setColor(this.commands, JGRPrefs.CMDColor);
        this.setColor(this.errors, JGRPrefs.ERRORColor);
        this.monospaced.setSelected(true);
        this.fontComboBox.setSelectedItem(JGRPrefs.FontName);
        this.sizeComboBox.setSelectedItem("" + JGRPrefs.FontSize);
        this.style.setSelectedItem(" ");
        this.tabwidth.setValue(new Integer(JGRPrefs.tabWidth));
        this.lineNumbers.setSelected(JGRPrefs.LINE_NUMBERS);
        this.highlight.setSelected(JGRPrefs.LINE_HIGHLIGHT);
        this.autotab.setSelected(JGRPrefs.AUTOTAB);
        this.setColor(this.brackets, JGRPrefs.BRACKETHighLight);
        this.working.setText(JGRPrefs.workingDirectory);
        this.hidden.setSelected(JGRPrefs.showHiddenFiles);
        this.helpPages.setValue(new Integer(JGRPrefs.maxHelpTabs));
        this.helpAgentConsole.setSelected(JGRPrefs.useHelpAgentConsole);
        this.helpAgentEditor.setSelected(JGRPrefs.useHelpAgentEditor);
        this.emacs.setSelected(JGRPrefs.useEmacsKeyBindings);
        this.savingWorkspace.setSelected(JGRPrefs.askForSavingWorkspace);
        this.setColor(this.comment, JGRPrefs.COMMENTColor);
        this.setColor(this.keyword, JGRPrefs.KEYWORDColor);
        this.setColor(this.numbers, JGRPrefs.NUMBERColor);
        this.setColor(this.strings, JGRPrefs.QUOTEColor);
        this.setColor(this.objects, JGRPrefs.OBJECTColor);
        this.boldKeywords.setSelected(JGRPrefs.KEYWORD_BOLD);
        this.italicObjects.setSelected(JGRPrefs.OBJECT_IT);
        this.italicComments.setSelected(JGRPrefs.COMMENT_IT);
        for (int i = 0; i < this.styleDef.length; ++i) {
            if (!JGRPrefs.COMMENTColor.equals(this.styleDef[i][0]) || !JGRPrefs.KEYWORDColor.equals(this.styleDef[i][1]) || !JGRPrefs.NUMBERColor.equals(this.styleDef[i][2]) || !JGRPrefs.QUOTEColor.equals(this.styleDef[i][3]) || !JGRPrefs.OBJECTColor.equals(this.styleDef[i][4]) || !new Boolean(JGRPrefs.KEYWORD_BOLD).equals(this.styleDef[i][5]) || !new Boolean(JGRPrefs.OBJECT_IT).equals(this.styleDef[i][6]) || !new Boolean(JGRPrefs.COMMENT_IT).equals(this.styleDef[i][7])) continue;
            this.style.setSelectedIndex(i + 1);
        }
    }

    public void resetToFactory() {
        this.style.setSelectedIndex(1);
        this.setColor(this.highlightColor, new Color(0xE0E0E0));
        this.setColor(this.results, Color.blue);
        this.setColor(this.commands, Color.red);
        this.setColor(this.errors, Color.red);
        this.monospaced.setSelected(true);
        this.fontComboBox.setSelectedItem("Monospaced");
        this.sizeComboBox.setSelectedItem("12");
        this.tabwidth.setValue(new Integer(4));
        this.lineNumbers.setSelected(true);
        this.highlight.setSelected(true);
        this.autotab.setSelected(true);
        this.setColor(this.brackets, new Color(200, 255, 255));
        this.working.setText(System.getProperty("user.home"));
        this.hidden.setSelected(false);
        this.helpPages.setValue(new Integer(10));
        this.helpAgentConsole.setSelected(true);
        this.helpAgentEditor.setSelected(true);
        this.emacs.setSelected(false);
        this.savingWorkspace.setSelected(true);
    }

    public boolean saveAll() {
        int n;
        int n2 = JGRPrefs.tabWidth;
        int n3 = JGRPrefs.maxHelpTabs;
        try {
            JGRPrefs.FontSize = Integer.parseInt((String)this.sizeComboBox.getSelectedItem());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Invalid Font Size");
            return false;
        }
        n2 = (Integer)this.tabwidth.getValue();
        if (n2 <= 0) {
            JOptionPane.showMessageDialog(this, "Invalid Tab Width");
            return false;
        }
        n3 = (Integer)this.helpPages.getValue();
        if (n3 <= 0) {
            JOptionPane.showMessageDialog(this, "Invalid number of help pages");
            return false;
        }
        File file = new File(this.working.getText());
        if (!file.exists() || !file.isDirectory()) {
            JOptionPane.showMessageDialog(this, "Invalid working directory");
            return false;
        }
        if (this.emacs.isSelected() && !Common.isMac() && (n = JOptionPane.showConfirmDialog(this, "emacs key bindings are unsafe on non-mac systems. \nare you sure you want to use them?", "emac warning", 0)) == 1) {
            return false;
        }
        JGRPrefs.tabWidth = n2;
        JGRPrefs.maxHelpTabs = n3;
        JGRPrefs.workingDirectory = this.working.getText();
        JGRPrefs.FontName = (String)this.fontComboBox.getSelectedItem();
        JGRPrefs.HIGHLIGHTColor = this.getColor(this.highlightColor);
        JGRPrefs.RESULTColor = this.getColor(this.results);
        JGRPrefs.CMDColor = this.getColor(this.commands);
        JGRPrefs.ERRORColor = this.getColor(this.errors);
        JGRPrefs.LINE_NUMBERS = this.lineNumbers.isSelected();
        JGRPrefs.LINE_HIGHLIGHT = this.highlight.isSelected();
        JGRPrefs.AUTOTAB = this.autotab.isSelected();
        JGRPrefs.BRACKETHighLight = this.getColor(this.brackets);
        JGRPrefs.showHiddenFiles = this.hidden.isSelected();
        JGRPrefs.useHelpAgentConsole = this.helpAgentConsole.isSelected();
        JGRPrefs.useHelpAgentEditor = this.helpAgentEditor.isSelected();
        JGRPrefs.useEmacsKeyBindings = this.emacs.isSelected();
        JGRPrefs.askForSavingWorkspace = this.savingWorkspace.isSelected();
        JGRPrefs.COMMENTColor = this.getColor(this.comment);
        JGRPrefs.KEYWORDColor = this.getColor(this.keyword);
        JGRPrefs.NUMBERColor = this.getColor(this.numbers);
        JGRPrefs.QUOTEColor = this.getColor(this.strings);
        JGRPrefs.OBJECTColor = this.getColor(this.objects);
        JGRPrefs.KEYWORD_BOLD = this.boldKeywords.isSelected();
        JGRPrefs.OBJECT_IT = this.italicObjects.isSelected();
        JGRPrefs.COMMENT_IT = this.italicComments.isSelected();
        JGRPrefs.apply();
        JGRPrefs.writePrefs(false);
        return true;
    }

    public static void addPanel(PJPanel pJPanel, ActionListener actionListener) {
        if (plugInPanels == null || plugInActionListeners == null) {
            plugInPanels = new Vector();
            plugInActionListeners = new Vector();
        }
        plugInPanels.add(pJPanel);
        plugInActionListeners.add(actionListener);
        if (instance != null) {
            PrefDialog.instance.tabbedPrefs.add(pJPanel);
            pJPanel.reset();
            PrefDialog.instance.okay.addActionListener(actionListener);
            PrefDialog.instance.cancel.addActionListener(actionListener);
            PrefDialog.instance.reset.addActionListener(actionListener);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okay) {
            if (this.saveAll()) {
                this.dispose();
            }
        } else if (object == this.cancel) {
            this.dispose();
        } else if (object == this.reset) {
            this.resetToFactory();
        } else if (object == this.workingButton) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setDialogTitle("Choose Working Directory");
            jFileChooser.setApproveButtonText("Choose");
            int n = jFileChooser.showOpenDialog(this.working);
            if (n == 1) {
                return;
            }
            if (jFileChooser.getSelectedFile() != null) {
                this.working.setText(jFileChooser.getSelectedFile().toString());
            }
        } else if (object == this.results) {
            Color color = JColorChooser.showDialog(this, "Choose Console Result Color", this.results.getBackground());
            if (color != null) {
                this.setColor(this.results, color);
            }
        } else if (object == this.commands) {
            Color color = JColorChooser.showDialog(this, "Choose Console Command Color", this.commands.getBackground());
            if (color != null) {
                this.setColor(this.commands, color);
            }
        } else if (object == this.errors) {
            Color color = JColorChooser.showDialog(this, "Choose Console Error Color", this.errors.getBackground());
            if (color != null) {
                this.setColor(this.errors, color);
            }
        } else if (object == this.monospaced) {
            if (this.monospaced.isSelected()) {
                this.setFontComboBox();
            } else {
                this.fontComboBox.setModel(new DefaultComboBoxModel<String>(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()));
            }
        } else if (object instanceof JButton) {
            Color color = JColorChooser.showDialog(this, "Choose Color", this.errors.getBackground());
            if (color != null) {
                this.setColor((JButton)object, color);
                this.style.setSelectedItem(" ");
            }
        } else if (object == this.boldKeywords) {
            this.style.setSelectedItem(" ");
        } else if (object == this.italicObjects) {
            this.style.setSelectedItem(" ");
        } else if (object == this.style && this.style.getSelectedIndex() != 0) {
            this.setStyle(this.style.getSelectedIndex() - 1);
        }
    }

    public static abstract class PJPanel
    extends JPanel {
        private static final long serialVersionUID = -3811864725637425691L;

        public abstract void reset();
    }
}

