/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.toolkit;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.JWindow;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.ibase.Common;

public class SplashScreen
extends JWindow
implements Runnable {
    private static final long serialVersionUID = 8996166449783183244L;
    private final Dimension screenSize = Common.getScreenRes();
    private final Dimension splashSize = new Dimension(300, 200);
    private Thread thread;
    private Image splash;
    private boolean contin = true;

    public SplashScreen() {
        try {
            this.splash = this.loadSplash("jgrsplash.jpg");
        }
        catch (Exception e) {
            new ErrorMsg(e);
        }
        this.setSize(this.splashSize);
        this.setLocation((this.screenSize.width - 300) / 2, (this.screenSize.height - 200) / 2);
        this.setBackground(Color.white);
        this.thread = new Thread(this);
    }

    public void paint(Graphics g) {
        try {
            if (this.splash != null) {
                g.drawImage(this.splash, 0, 0, this.splash.getWidth(this), this.splash.getHeight(this), this);
            }
            g.setFont(new Font("Dialog", 1, 26));
            g.drawString("JGR", 175, 40);
            g.setFont(new Font("Dialog", 1, 16));
            g.drawString("Java Gui for R", 150, 70);
            g.setFont(new Font("Dialog", 0, 11));
            g.drawString("Version: " + JGR.VERSION, 175, 85);
            g.setFont(new Font("Dialog", 2, 13));
            g.drawString("Markus Helbig", 163, 119);
            g.drawString("Simon Urbanek", 160, 134);
            g.drawString("Ian Fellows", 160, 149);
            g.setFont(new Font("Dialog", 0, 12));
            g.setColor(Color.blue);
            g.drawString("http://www.rosuda.org", 150, this.splashSize.height - 35);
            g.setColor(Color.black);
            g.setFont(new Font("Dialog", 0, 12));
            g.drawString("(c) 2003 - 2017, RoSuDa, Univ. Augsburg", 10, this.splashSize.height - 10);
            g.drawRect(0, 0, this.splashSize.width - 1, this.splashSize.height - 1);
        }
        catch (Exception e) {
            g.setFont(new Font("Dialog", 0, 12));
            g.drawString("SplashScreen (something has gone wrong)", 10, 10);
            new ErrorMsg(e);
        }
    }

    public Image loadSplash(String logo) {
        URL location = this.getClass().getResource("/" + logo);
        if (location == null) {
            location = this.getClass().getResource("/splash.jpg");
        }
        Image img = Toolkit.getDefaultToolkit().getImage(location);
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(img, 0);
        try {
            mt.waitForAll();
        }
        catch (Exception e) {
            new ErrorMsg(e);
        }
        return img;
    }

    public void start() {
        this.setVisible(true);
        this.thread.start();
    }

    public void run() {
        while (this.contin) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception e) {
                new ErrorMsg(e);
            }
        }
    }

    public void stop() {
        this.setVisible(false);
        this.dispose();
        this.thread = null;
        this.contin = false;
    }
}

