/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.JGR.robjects.RObject;
import org.rosuda.JGR.toolkit.DataTable;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.REngine.REXPLogical;
import org.rosuda.ibase.SVarSet;

public class TxtTableLoader
extends JFrame {
    private static final long serialVersionUID = -1441684043207305950L;
    private final String[] quotes = new String[]{"", "\\\"", "\\'"};
    private final String[] seps = new String[]{"\\t", "", ",", ";", "|"};
    private String file;
    private JPanel jPanel1;
    private JLabel quoteLabel;
    private JCheckBox header;
    private JLabel sepsBoxLabel;
    private JComboBox quoteBox;
    private JComboBox sepsBox;
    private JTable dataTable;
    private JPanel tablePanel;
    private JButton cancel;
    private JButton load;
    private JPanel buttonPanel;
    private JScrollPane tablePane;
    private String previewName = "...temp_data12121...";
    private String dataName = null;

    public TxtTableLoader(String fileName, String rName) {
        this.file = fileName;
        this.dataName = rName;
        this.initGUI();
        this.checkFile();
        this.loadPreview();
    }

    public TxtTableLoader() {
        this.initGUI();
    }

    public static void run(String fileName, String rName) {
        final String theFile = fileName;
        final String theName = rName;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TxtTableLoader inst = new TxtTableLoader(theFile, theName);
                inst.setLocationRelativeTo(null);
                inst.setVisible(true);
            }
        });
    }

    public void setFile(String fileName) {
        this.file = fileName;
    }

    private void initGUI() {
        try {
            this.setTitle("Read Delimited File");
            AnchorLayout thisLayout = new AnchorLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setDefaultCloseOperation(2);
            this.jPanel1 = new JPanel();
            AnchorLayout jPanel1Layout = new AnchorLayout();
            this.getContentPane().add((Component)this.jPanel1, new AnchorConstraint(1, 963, 1001, 39, 1, 1, 1, 1));
            this.jPanel1.setPreferredSize(new Dimension(414, 333));
            this.jPanel1.setLayout(jPanel1Layout);
            this.tablePanel = new JPanel();
            BorderLayout tablePanelLayout = new BorderLayout();
            this.tablePanel.setLayout(tablePanelLayout);
            this.jPanel1.add((Component)this.tablePanel, new AnchorConstraint(328, 1001, 863, 1, 1, 1, 1, 1));
            this.tablePanel.setPreferredSize(new Dimension(356, 178));
            DefaultTableModel dataTableModel = new DefaultTableModel(new String[][]{{"Select File to load Data"}}, new String[]{"Column 1"});
            this.dataTable = new JTable();
            this.dataTable.setModel(dataTableModel);
            this.tablePane = new JScrollPane(this.dataTable);
            this.tablePanel.add(this.tablePane);
            this.tablePane.setPreferredSize(new Dimension(356, 167));
            this.dataTable.setAutoResizeMode(0);
            this.header = new JCheckBox();
            this.jPanel1.add((Component)this.header, new AnchorConstraint(211, 1001, 265, 763, 1, 1, 1, 1));
            this.header.setText("Header");
            this.header.setPreferredSize(new Dimension(91, 18));
            this.header.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    TxtTableLoader.this.headerActionPerformed(evt);
                }
            });
            this.quoteLabel = new JLabel();
            this.jPanel1.add((Component)this.quoteLabel, new AnchorConstraint(148, 894, 190, 350, 1, 1, 1, 1));
            this.quoteLabel.setText("Quote");
            this.quoteLabel.setPreferredSize(new Dimension(179, 14));
            this.sepsBoxLabel = new JLabel();
            this.jPanel1.add((Component)this.sepsBoxLabel, new AnchorConstraint(148, 426, 190, 1, 1, 1, 1, 1));
            this.sepsBoxLabel.setText("Record Seperator");
            this.sepsBoxLabel.setPreferredSize(new Dimension(163, 14));
            DefaultComboBoxModel<String> quoteBoxModel = new DefaultComboBoxModel<String>(new String[]{"None", "Double Quote (\")", "Single Quote (')"});
            this.quoteBox = new JComboBox();
            this.jPanel1.add((Component)this.quoteBox, new AnchorConstraint(208, 750, 271, 350, 1, 1, 1, 1));
            this.quoteBox.setModel(quoteBoxModel);
            this.quoteBox.setPreferredSize(new Dimension(120, 21));
            this.quoteBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    TxtTableLoader.this.quoteBoxActionPerformed(evt);
                }
            });
            DefaultComboBoxModel<String> sepsBoxModel = new DefaultComboBoxModel<String>(new String[]{"Tab (\\t)", "Space (\\w)", "Comma (,)", ";", "|"});
            this.sepsBox = new JComboBox();
            this.sepsBox.setPreferredSize(new Dimension(120, 21));
            this.jPanel1.add((Component)this.sepsBox, new AnchorConstraint(208, 300, 271, 1, 1, 1, 1, 1));
            this.sepsBox.setModel(sepsBoxModel);
            this.sepsBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    TxtTableLoader.this.sepsBoxActionPerformed(evt);
                }
            });
            this.buttonPanel = new JPanel();
            FlowLayout buttonPanelLayout = new FlowLayout();
            buttonPanelLayout.setAlignment(2);
            this.jPanel1.add((Component)this.buttonPanel, new AnchorConstraint(881, 998, 1001, -15, 1, 1, 0, 1));
            this.buttonPanel.setPreferredSize(new Dimension(361, 40));
            this.buttonPanel.setLayout(buttonPanelLayout);
            this.cancel = new JButton();
            this.buttonPanel.add(this.cancel);
            this.cancel.setText("Cancel");
            this.cancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    TxtTableLoader.this.cancelActionPerformed(evt);
                }
            });
            this.load = new JButton();
            this.buttonPanel.add(this.load);
            this.load.setText("Load");
            this.load.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    TxtTableLoader.this.loadActionPerformed(evt);
                }
            });
            this.pack();
            this.setSize(425, 368);
        }
        catch (Exception e) {
            new ErrorMsg(e);
        }
    }

    private void checkFile() {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.file));
            String line1 = null;
            String line2 = null;
            if (reader.ready()) {
                line1 = reader.readLine();
            }
            if (reader.ready()) {
                line2 = reader.readLine();
            }
            reader.close();
            if (line2 != null) {
                int i = line2.indexOf("\"");
                if (i > -1 && line2.indexOf("\"", i + 1) > -1) {
                    this.quoteBox.setSelectedItem("Double Quote (\")");
                } else {
                    i = line2.indexOf("'");
                    if (i > -1 && line2.indexOf("'", i + 1) > -1) {
                        this.quoteBox.setSelectedItem("Single Quote (')");
                    } else {
                        this.quoteBox.setSelectedItem("None");
                    }
                }
                this.sepsBox.setSelectedItem("Space (\\w)");
                i = line2.indexOf("\t");
                if (i > -1 && line2.indexOf("\t", i + 1) > -1) {
                    this.sepsBox.setSelectedItem("Tab (\\t)");
                }
                if ((i = line2.indexOf(";")) > -1 && line2.indexOf(";", i + 1) > -1) {
                    this.sepsBox.setSelectedItem(";");
                }
                if ((i = line2.indexOf(",")) > -1 && line2.indexOf(",", i + 1) > -1) {
                    this.sepsBox.setSelectedItem("Comma (,)");
                }
                if ((i = line2.indexOf("|")) > -1 && line2.indexOf("|", i + 1) > -1) {
                    this.sepsBox.setSelectedItem("|");
                }
            }
            if (line1 != null && line2 != null) {
                String sep = this.seps[this.sepsBox.getSelectedIndex()];
                sep = sep == "\\t" ? "\t" : sep;
                int z1 = 0;
                int z2 = 0;
                if (sep.length() == 0) {
                    z1 = new StringTokenizer(line1).countTokens();
                    z2 = new StringTokenizer(line2).countTokens();
                } else {
                    int i = -1;
                    while ((i = line1.trim().indexOf(sep, i + 1)) > -1) {
                        ++z1;
                    }
                    i = -1;
                    while ((i = line2.trim().indexOf(sep, i + 1)) > -1) {
                        ++z2;
                    }
                }
                if (z1 + 1 == z2 || z1 == z2 && line1.matches("^[a-zA-Z\"].*")) {
                    this.header.setSelected(true);
                } else {
                    this.header.setSelected(false);
                }
            }
        }
        catch (Exception e) {
            new ErrorMsg(e);
        }
    }

    public void loadInR(String name, boolean preview) {
        String fileName = this.file.toString();
        String useSep = this.sepsBox.getSelectedIndex() >= this.seps.length ? this.sepsBox.getSelectedItem().toString() : this.seps[this.sepsBox.getSelectedIndex()];
        String useQuote = this.quoteBox.getSelectedIndex() >= this.quotes.length ? this.quoteBox.getSelectedItem().toString() : this.quotes[this.quoteBox.getSelectedIndex()];
        String cmd = (preview ? "try(" : "") + name + " <- read.table(\"" + fileName + "\",header=" + (this.header.isSelected() ? "T" : "F") + ",sep=\"" + useSep + "\"" + (preview ? ",nrows=10" : "") + ",quote=\"" + useQuote + "\")" + (preview ? ",silent=TRUE)" : "");
        if (preview) {
            try {
                JGR.timedEval(cmd);
            }
            catch (Exception e) {}
        } else {
            this.execute(cmd, true);
        }
    }

    private void loadPreview() {
        this.loadInR(this.previewName, true);
        try {
            JGR.timedEval(".refreshObjects()");
        }
        catch (Exception e) {
            // empty catch block
        }
        RObject obj = new RObject(this.previewName, "data.frame", null, false);
        SVarSet vs = RController.newSet(obj);
        DataTable rTable = new DataTable(vs, "data.frame", false, false);
        this.dataTable.setModel(rTable.getJTable().getModel());
        this.dataTable.setTableHeader(rTable.getJTable().getTableHeader());
        rTable.dispose();
        try {
            REXPLogical result = (REXPLogical)JGR.timedEval("\"" + this.previewName + "\" %in% ls()");
            if (result == null || result.isTRUE()[0]) {
                JGR.timedEval("rm(" + this.previewName + ")");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void execute(String cmd, boolean hist) {
        JGR.MAINRCONSOLE.execute(cmd, hist);
    }

    private void loadActionPerformed(ActionEvent evt) {
        this.loadInR(this.dataName, false);
        this.dispose();
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void sepsBoxActionPerformed(ActionEvent evt) {
        this.loadPreview();
    }

    private void quoteBoxActionPerformed(ActionEvent evt) {
        this.loadPreview();
    }

    private void headerActionPerformed(ActionEvent evt) {
        this.loadPreview();
    }

    public void dispose() {
        super.dispose();
    }
}

