% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{logicals}
\alias{logicals}
\alias{\%gele\%}
\alias{\%gel\%}
\alias{\%gle\%}
\alias{\%gl\%}
\alias{\%sgele\%}
\alias{\%sgel\%}
\alias{\%sgle\%}
\alias{\%sgl\%}
\alias{\%sge\%}
\alias{\%sg\%}
\alias{\%sle\%}
\alias{\%sl\%}
\alias{\%nin\%}
\alias{\%sin\%}
\alias{\%snin\%}
\alias{\%flipIn\%}
\title{Several logical range comparison helpers}
\usage{
e1 \%gele\% e2

e1 \%gel\% e2

e1 \%gle\% e2

e1 \%gl\% e2

e1 \%sgele\% e2

e1 \%sgel\% e2

e1 \%sgle\% e2

e1 \%sgl\% e2

e1 \%sge\% e2

e1 \%sg\% e2

e1 \%sle\% e2

e1 \%sl\% e2

e1 \%nin\% e2

e1 \%sin\% e2

e1 \%snin\% e2

e1 \%flipIn\% e2
}
\arguments{
\item{e1}{A number of vector to be evaluated}

\item{e2}{A vector of one or two numbers used to denote the
limits for logical comparison.}
}
\value{
A logical vector of the same length as \code{e1} or for
 those functions prefaced with \dQuote{s} the subsetted vector.
}
\description{
Several logical range comparison helpers
}
\examples{

1:5 \%gele\% c(2, 4)
1:5 \%gele\% c(4, 2) # order does not matter uses min / max

1:5 \%gel\% c(2, 4)
1:5 \%gel\% c(4, 2) # order does not matter uses min / max

1:5 \%gle\% c(2, 4)
1:5 \%gle\% c(4, 2) # order does not matter uses min / max

1:5 \%gl\% c(2, 4)
1:5 \%gl\% c(4, 2) # order does not matter uses min / max

1:5 \%sgele\% c(2, 4)
1:5 \%sgele\% c(4, 2) # order does not matter uses min / max

1:5 \%sgel\% c(2, 4)
1:5 \%sgel\% c(4, 2) # order does not matter uses min / max

1:5 \%sgle\% c(2, 4)
1:5 \%sgle\% c(4, 2) # order does not matter uses min / max

1:5 \%sgl\% c(2, 4)
1:5 \%sgl\% c(4, 2) # order does not matter uses min / max

1:5 \%sge\% 2
1:5 \%sge\% 4

1:5 \%sg\% 2
1:5 \%sg\% 4

1:5 \%sle\% 2
1:5 \%sle\% 4

1:5 \%sl\% 2
1:5 \%sl\% 4

1:5 \%nin\% c(2, 99)
c("jack", "jill", "john", "jane") \%nin\% c("jill", "jane", "bill")

1:5 \%sin\% c(2, 99)
c("jack", "jill", "john", "jane") \%sin\% c("jill", "jane", "bill")

1:5 \%snin\% c(2, 99)
c("jack", "jill", "john", "jane") \%snin\% c("jill", "jane", "bill")
}
