/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.net.URL;
import java.util.Hashtable;
import javax.help.BadIDException;
import javax.help.DefaultHelpModel;
import javax.help.HelpSet;
import javax.help.HelpUtilities;
import javax.help.InvalidHelpSetContextException;
import javax.help.Map;
import javax.help.TextHelpModel;
import javax.help.event.HelpModelListener;
import javax.help.event.TextHelpModelListener;
import javax.help.plaf.HelpContentViewerUI;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.EditorKit;

public class JHelpContentViewer
extends JComponent {
    protected TextHelpModel model;
    private Hashtable kitRegistry;
    private boolean debug = false;

    static {
        HelpUtilities.installLookAndFeelDefaults();
    }

    public JHelpContentViewer() {
        this.setModel(new DefaultHelpModel(null));
        this.updateUI();
    }

    public JHelpContentViewer(HelpSet helpSet) {
        this.setModel(new DefaultHelpModel(helpSet));
        this.updateUI();
    }

    public JHelpContentViewer(TextHelpModel textHelpModel) {
        this.setModel(textHelpModel);
        this.updateUI();
    }

    public void addHelpModelListener(HelpModelListener helpModelListener) {
        this.getModel().addHelpModelListener(helpModelListener);
    }

    public void addHighlight(int n, int n2) {
        this.model.addHighlight(n, n2);
    }

    public void addTextHelpModelListener(TextHelpModelListener textHelpModelListener) {
        this.getModel().addTextHelpModelListener(textHelpModelListener);
    }

    public EditorKit createEditorKitForContentType(String string) {
        EditorKit editorKit = null;
        if (this.kitRegistry == null) {
            this.kitRegistry = new Hashtable();
        } else {
            editorKit = (EditorKit)this.kitRegistry.get(string);
        }
        if (editorKit == null) {
            HelpSet helpSet = this.model.getHelpSet();
            String string2 = (String)helpSet.getKeyData(HelpSet.kitTypeRegistry, string);
            ClassLoader classLoader = (ClassLoader)helpSet.getKeyData(HelpSet.kitLoaderRegistry, string);
            if (classLoader == null) {
                classLoader = helpSet.getLoader();
            }
            try {
                Class<?> clazz = classLoader != null ? classLoader.loadClass(string2) : Class.forName(string2);
                editorKit = (EditorKit)clazz.newInstance();
                this.kitRegistry.put(string, editorKit);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                editorKit = null;
            }
        }
        if (editorKit != null) {
            return (EditorKit)editorKit.clone();
        }
        editorKit = JEditorPane.createEditorKitForContentType(string);
        return editorKit;
    }

    private void debug(String string) {
        if (this.debug) {
            System.err.println("JHelpContentViewer: " + string);
        }
    }

    public URL getCurrentURL() {
        return this.model.getCurrentURL();
    }

    public String getDocumentTitle() {
        return this.model.getDocumentTitle();
    }

    public TextHelpModel getModel() {
        return this.model;
    }

    public HelpContentViewerUI getUI() {
        return (HelpContentViewerUI)this.ui;
    }

    public String getUIClassID() {
        return "HelpContentViewerUI";
    }

    public void removeAllHighlights() {
        this.model.removeAllHighlights();
    }

    public void removeHelpModelListener(HelpModelListener helpModelListener) {
        this.getModel().removeHelpModelListener(helpModelListener);
    }

    public void removeHelpModelListener(TextHelpModelListener textHelpModelListener) {
        this.getModel().removeTextHelpModelListener(textHelpModelListener);
    }

    public void setCurrentID(String string) throws BadIDException {
        try {
            this.model.setCurrentID(Map.ID.create(string, this.getModel().getHelpSet()));
        }
        catch (InvalidHelpSetContextException invalidHelpSetContextException) {}
    }

    public void setCurrentID(Map.ID iD) throws InvalidHelpSetContextException {
        this.model.setCurrentID(iD);
    }

    public void setCurrentURL(URL uRL) {
        this.model.setCurrentURL(uRL);
    }

    public void setModel(TextHelpModel textHelpModel) {
        this.debug("setModel: " + textHelpModel);
        TextHelpModel textHelpModel2 = this.model;
        if (textHelpModel != textHelpModel2) {
            this.model = textHelpModel;
            this.firePropertyChange("helpModel", textHelpModel2, this.model);
            this.invalidate();
        }
    }

    public void setUI(HelpContentViewerUI helpContentViewerUI) {
        this.debug("setUI");
        if ((HelpContentViewerUI)this.ui != helpContentViewerUI) {
            super.setUI(helpContentViewerUI);
            this.repaint();
        }
    }

    public void updateUI() {
        ComponentUI componentUI = UIManager.getUI(this);
        this.setUI((HelpContentViewerUI)componentUI);
        this.invalidate();
    }
}

