% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{residuals.JointAI}
\alias{residuals.JointAI}
\title{Extract residuals from an object of class JointAI}
\usage{
\method{residuals}{JointAI}(object, type = c("deviance", "response",
  "working"), ...)
}
\arguments{
\item{object}{object inheriting from class 'JointAI'}

\item{type}{type of residuals: \code{"deviance"}, \code{"response"},
\code{"working"}}

\item{...}{currently not used}
}
\description{
Extract residuals from an object of class JointAI
}
\section{Note}{

\itemize{
\item For mixed models residuals are currently calculated using the fixed effects only.
\item For ordinal (mixed) models and parametric survival models only \code{type = "response"} is available.
\item For Cox proportional hazards models residuals are not yet implemented.
}
}

\examples{
mod <- glm_imp(B1 ~ C1 + C2 + O1, data = wideDF, n.iter = 100,
               family = binomial(), mess = FALSE)
summary(residuals(mod, type = 'response'))
summary(residuals(mod, type = 'working'))


}
