% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ttestevidence.R
\name{ttestEvidence}
\alias{ttestEvidence}
\title{Justify your alpha level by avoiding the Lindley paradox or aiming for moderate or strong evidence when using a t-test.}
\usage{
ttestEvidence(
  evidence,
  n1,
  n2 = 0,
  one.sided = FALSE,
  rscale = sqrt(2)/2,
  printplot = FALSE
)
}
\arguments{
\item{evidence}{Desired level of evidence: "Lindley" to avoid the Lindley Paradox, "moderate" to achieve moderate evidence and "strong" to achieve strong evidence.
Users that are more familiar with Bayesian statistics can also directly enter their desired Bayes factor.}

\item{n1}{Sample size in Group 1.}

\item{n2}{Sample size in Group 2. Leave blank for a one-sample or paired-sample}

\item{one.sided}{Indicates whether the test is one sided or two sided.}

\item{rscale}{Scale of the Cauchy prior}

\item{printplot}{If true prints a plot relating Bayes factors and p-values.}
}
\value{
numeric alpha level required to avoid Lindley's paradox.
}
\description{
Justify your alpha level by avoiding the Lindley paradox or aiming for moderate or strong evidence when using a t-test.
}
\section{References}{

Maier & Lakens (2021). Justify Your Alpha: A Primer on Two Practical Approaches
}

\examples{
## Avoid the Lindley paradox for a two sample t-test with 300 participants per condition
ttestEvidence("lindley", 300, 300)
}
