% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_knn_index_dist.R
\name{distMat.knn.index.dist}
\alias{distMat.knn.index.dist}
\title{indices and distances of k-nearest-neighbors using a distance matrix}
\usage{
distMat.knn.index.dist(DIST_mat, TEST_indices = NULL, k = 5,
  threads = 1, minimize = T)
}
\arguments{
\item{DIST_mat}{a distance matrix (square matrix) having a diagonal filled with either zero's (\emph{0}) or NA's (\emph{missing values})}

\item{TEST_indices}{a numeric vector specifying the indices of the test data in the distance matrix (row-wise or column-wise). If the parameter equals NULL then no test data is included in the distance matrix}

\item{k}{an integer specifying the k-nearest-neighbors}

\item{threads}{the number of cores to be used in parallel (openmp will be employed)}

\item{minimize}{either TRUE or FALSE. If TRUE then lower values will be considered as relevant for the k-nearest search, otherwise higher values.}
}
\value{
a list of length 2. The first sublist returns the indices and the second the distances of the k nearest neighbors for each observation.
If TEST_indices is NULL the number of rows of each sublist equals the number of rows in the DIST_mat data. If TEST_indices is not NULL the number of rows of each sublist equals the length of the input TEST_indices.
}
\description{
indices and distances of k-nearest-neighbors using a distance matrix
}
\details{
This function takes a number of arguments and it returns the indices and distances of the k-nearest-neighbors for each observation. If TEST_indices is NULL then the indices-distances for the DIST_mat be returned, whereas if TEST_indices is not NULL then the indices-distances for the test data only will be returned.
}
\examples{

data(Boston)

X = Boston[, -ncol(Boston)]

dist_obj = dist(X)

dist_mat = as.matrix(dist_obj)

out = distMat.knn.index.dist(dist_mat, TEST_indices = NULL, k = 5)

}
\author{
Lampros Mouselimis
}
