% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/L1centrality-package.R
\docType{package}
\name{L1centrality-package}
\alias{L1centrality-package}
\alias{L1centrality}
\title{L1centrality: Graph/Network Analysis Based on \out{<i>L</i><sub>1</sub>}
Centrality}
\description{
Analyze graph/network data using \out{<i>L</i><sub>1</sub>} centrality and
prestige. Functions for deriving global, local, and group
\out{<i>L</i><sub>1</sub>} centrality/prestige are provided. Routines for
visual inspection of a graph/network are also provided. Details are in Kang
and Oh (2024a,b) and Kang (2025).
}
\details{
Every function inside this package supports a distinct variety of graphs.
Edge weights can be considered by all functions. Additionally, it is
assumed that the graph to be analyzed is a connected graph in the case of an
undirected graph, or a strongly connected graph in the case of a directed
graph.

Certain functions exclusively accommodate undirected graphs without vertex
multiplicity, while others support both directed and
undirected graphs with vertex multiplicities. The following table provides a
concise overview of the support range for each function.

\tabular{rccc}{
\strong{Functions} \tab \strong{Undirected graph} \tab \strong{Directed graph} \tab \strong{Vertex multiplicity}\cr
\code{\link[=L1cent]{L1cent()}}, \code{\link[=L1centNB]{L1centNB()}}, \code{\link[=L1centLOC]{L1centLOC()}}, \code{\link[=L1centGROUP]{L1centGROUP()}} \tab O \tab O \tab O \cr
\code{\link[=L1centEDGE]{L1centEDGE()}} \tab O \tab X \tab O \cr
\code{\link[=L1centMDS]{L1centMDS()}} \tab O \tab X \tab X
}
}
\references{
S. Kang. \emph{Topics in Non-Euclidean Dimension Reduction}. PhD
thesis, Seoul National University, 2025.

S. Kang and H.-S. Oh. On a notion of graph centrality based on
\ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}} data depth.
\emph{arXiv preprint arXiv:2404.13233}, 2024a.

S. Kang and H.-S. Oh.
\ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}} prominence measures
for directed graphs. \emph{arXiv preprint arXiv:2408.12078}, 2024b.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/seungwoo-stat/L1centrality}
  \item Report bugs at \url{https://github.com/seungwoo-stat/L1centrality/issues}
}

}
\author{
\strong{Maintainer}: Seungwoo Kang \email{kangsw0401@snu.ac.kr} (\href{https://orcid.org/0000-0001-8082-0794}{ORCID})

Authors:
\itemize{
  \item Hee-Seok Oh \email{heeseok@stats.snu.ac.kr}
}

}
\keyword{internal}
