% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataloader.R
\name{get_dataloaders}
\alias{get_dataloaders}
\title{Wrapper around \code{torch::dataloader}}
\usage{
get_dataloaders(
  dataset,
  train_proportion,
  train_batch_size,
  test_batch_size,
  standardize = TRUE,
  shuffle_train = TRUE,
  shuffle_test = FALSE,
  seed = 1
)
}
\arguments{
\item{dataset}{A \code{data.frame}. The last column is assumed to be the dependent variable.}

\item{train_proportion}{numeric, between 0 and 1. Proportion of data to be used for training.}

\item{train_batch_size}{integer, number of samples per batch in the training dataloader.}

\item{test_batch_size}{integer, number of sampels per batch in the testing dataloader.}

\item{standardize}{logical, whether to standardize input-features, default is TRUE.}

\item{shuffle_train}{logical, whether to shuffle the training data each epoch. default is TRUE}

\item{shuffle_test}{logical, shuffle test data, default is FALSE. Usually not needed.}

\item{seed}{integer. Used for reproducibility purposes in the train/test split.}
}
\value{
A list containing:
\describe{
\item{train_loader}{A \code{torch::dataloader} for the training data.}
\item{test_loader}{A \code{torch::dataloader} for the test data.}
}
}
\description{
Avoids users having to manually define their own dataloaders.
}
