% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All9Models.R
\name{LDL_ML_Main_All_Models}
\alias{LDL_ML_Main_All_Models}
\title{Create, train, assess and return all ML prediction models}
\usage{
LDL_ML_Main_All_Models(
  DataCSV,
  partition,
  ReportMultiPlot = TRUE,
  ComparisonPlot = TRUE
)
}
\arguments{
\item{DataCSV}{The .csv or a data table file, path containing the data with which the model will be trained and assessed. Must contain
at least 4 columns, named "CHOL", "HDL", "TG" and "LDLd", through which the train data and the validation data will be
extracted.}

\item{partition}{A value in the range (0,1) that stipulates what percentage of the input data will be
used for training the models, while the remainder will be used to assess them.}

\item{ReportMultiPlot}{A boolean that allows the user to select whether the LDL_ML_Main function will
plot a diagram with 5 plots, relating different stats on the newly created model. Preset to TRUE.}

\item{ComparisonPlot}{A boolean that allows the user to select whether the LDL_ML_Main_All_Models function will
plot a comparison plot, relating different stats on the newly created models. Preset to TRUE.}
}
\value{
It initializes and returns all ML prediction models. In case of bad input,
it will return  -2 (illegitimate partition input).
}
\description{
This function reads data from a DATACSV.csv or a data.table file.It partitions them according to the partition parameter
and labels them, trains all of the models, assesses them using the second set of the partition data, optionally
plots some info relating the accuracy of the models and returns them for further use.
}
\examples{
\donttest{
allModels = LDL_ML_Main_All_Models(SampleData,0.8,ReportMultiPlot = FALSE,ComparisonPlot=FALSE)
}
}
