% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OLHD.C2007.R
\name{OLHD.C2007}
\alias{OLHD.C2007}
\title{Orthogonal Latin Hypercube Design}
\usage{
OLHD.C2007(m)
}
\arguments{
\item{m}{A positive integer, and it must be greater than or equal to 2.}
}
\value{
If all inputs are logical, then the output will be an orthogonal LHD with the following run size: \code{n=2^m+1} and the following factor size: \code{k=m+{m-1 \\choose 2}}.
}
\description{
\code{OLHD.C2007} returns a \code{2^m+1} by \code{m+{m-1 \\choose 2}} orthogonal Latin hypercube design generated by the construction method of Cioppa and Lucas (2007)
}
\examples{
#create an orthogonal LHD with m=4. So n=2^m+1=17 and k=4+3=7
OLHD.C2007(m=4)

#create an orthogonal LHD with m=5. So n=2^m+1=33 and k=5+6=11
OLHD.C2007(m=5)

}
\references{
Cioppa, T.M., and Lucas, T.W. (2007) Efficient nearly orthogonal and space-filling Latin hypercubes. \emph{Technometrics}, \strong{49}(1), 45-55.
}
