\name{Ldei}
\alias{Ldei}
\alias{Ldei.lim}
\alias{Ldei.limfile}
\alias{Ldei.character}
\alias{Ldei.double}

\title{
  Solves a linear inverse model using least distance programming
}

\description{
  Solves a linear inverse model using least distance programming,
  i.e. minimizes the sum of squared unknowns.

  Input presented either:

  \itemize{
    \item as matrices E, F, A, B, G, H (Ldei.double)
    \item as a list (Ldei.lim) or
    \item as a lim input file (Ldei.limfile)
  }
}

\usage{
Ldei(...)
\method{Ldei}{lim}(lim, ...)
\method{Ldei}{limfile}(file, verbose = TRUE, ...)
\method{Ldei}{character}(...)
\method{Ldei}{double}(...)
}
\arguments{
  \item{lim }{a list that contains the linear inverse model
    specification, as  generated by function \code{setup.limfile}.
  }
  \item{file }{name of the inverse input file.
  }
  \item{verbose }{if \code{TRUE}: prints warnings and messages to the screen.
  }
  \item{... }{other arguments passed to function
    \code{\link[limSolve]{ldei}} from package\code{limSolve}.
  }
}

\value{
  a list containing:
  \item{X }{vector containing the solution of the least distance problem.
  }
  \item{unconstrained.Solution }{vector containing the unconstrained
    solution of the least distance problem.
  }
  \item{residualNorm }{scalar, the sum of residuals of equalities and
    violated inequalities.
  }
  \item{solutionNorm }{scalar, the value of the quadratic function
    at the solution.
  }
  \item{IsError }{logical, \code{TRUE}, if an error occurred.
  }
  \item{Error }{ldei error text.
  }
  \item{type }{ldei.
  }
}

\author{
  Karline Soetaert <karline.soetaert@nioz.nl>
}

\examples{
Ldei(LIMRigaAutumn)
}

\references{
  Lawson C.L.and Hanson R.J. 1974. SOLVING LEAST SQUARES PROBLEMS,
  Prentice-Hall

  Lawson C.L.and Hanson R.J. 1995. Solving Least Squares Problems.
   SIAM classics in applied mathematics, Philadelphia.        (reprint of book)
}

\details{Solves the following inverse problem:
  \deqn{\min(\sum {Cost_i*x_i}^2)} subject to
  \deqn{Ax=B}
  \deqn{Gx>=H}
}
 
\seealso{
  \code{\link[limSolve]{ldei}}, the more general function from package limSolve.

  \code{\link{Linp}}, to solve the linear inverse problem by linear programming.

  \code{\link{Lsei}}, to solve the linear inverse problem by lsei (least
    squares with equality and inequality constraints).

  function \code{\link[limSolve]{ldei}} from package\code{limSolve}.
}

\keyword{algebra}
\keyword{array}
\keyword{optimize}

