% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/mrgsn.R
\name{mrgsn}
\alias{mrgsn}
\alias{mrgsn.default}
\title{Murugesan & Perumalsamy (2005) Method}
\usage{
mrgsn(...)

\method{mrgsn}{default}(XYdt, ...)
}
\arguments{
\item{...}{Additional optional arguments. None are used at present.}

\item{XYdt}{- Binodal Experimental data that will be used in the nonlinear fit}
}
\value{
Parameters P and Statistical data
}
\description{
Murugesan and Perumalsamy published a paper in the Journal of Chemical Engineering Data describing
 how they used a set of equations to fit and study a PEG/Salt Aqueous Two-Phase System. They also correlated
  Tieline data using the Othmer-Tobias and Bancraft equations and the osmotic virial equation (the last one
   wasn't implemented yet). This R method implements the methodology described in the referred article.

Perform a nonlinear regression fit in order to determine the equation's parameters.
}
\details{


The function returns three parameters after fitting experimental data to the equation
 proposed Murugesan & Perumalsamy (2005)
}
\examples{
#Populating variable XYdt with binodal data
XYdt <- peg4kslt[,1:2]
#Fitting XYdt using Murugesan's function
mrgsn(XYdt)
}
\references{
Murugesan, T. and M. Perumalsamy, Liquid-Liquid Equilibria of Poly(ethylene glycol) 2000 + Sodium
 Citrate + Water at (25, 30, 35, 40, and 45) C. Journal of Chemical & Engineering Data, 2005. 50(4): p. 1392-1395.
}
\seealso{
\itemize{
\item \code{\link{mrgsn.default}}
\item \code{\link{mrgsn.othmer}}
\item \code{\link{mrgsn.bancroft}}
\item \code{\link{mrgsn.plot}}
}
}

