% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LST.R
\name{SCA}
\alias{SCA}
\title{Single channel algorithm}
\usage{
SCA(
  TIR = TIR,
  BT = BT,
  tau = tau,
  E = E,
  dlrad = dlrad,
  ulrad = ulrad,
  band = band
)
}
\arguments{
\item{TIR}{Raster* object, Landsat band 10 or 11}

\item{BT}{Raster* object, brightness temperature}

\item{tau}{Atmospheric transmittance}

\item{E}{Raster* object, Land Surface Emissivity calculated according to Van de Griend and Owe 1993 or Valor and Caselles 1996 or Sobrino et al. 2008}

\item{dlrad}{Downwelling radiance calculated from https://atmcorr.gsfc.nasa.gov/}

\item{ulrad}{upwelling radiance calculated from https://atmcorr.gsfc.nasa.gov/}

\item{band}{A string specifying which Landsat 8 thermal band to use. It can be "band 10" or
"band 11"}
}
\value{
RasterLayer
}
\description{
This function calculates Land Surface Temperature using single channel algorithm
}
\examples{
TIR <- raster::raster(ncol=100, nrow=100)
set.seed(2)
raster::values(TIR) = runif(10000, min=27791, max=30878)
BT <- raster::raster(ncol=100, nrow=100)
set.seed(2)
raster::values(BT) = runif(10000, min=298, max=305)
E <- raster::raster(ncol=100, nrow=100)
set.seed(2)
raster::values(E) = runif(10000, min=0.96, max=0.99)
Ts_SCA <- SCA(TIR = TIR, BT = BT, tau = 0.86, E = E, 
		dlrad = 2.17, ulrad = 1.30, band = "band 11")
}
