#' Space Shuttle O-Ring Failures
#'
#' On January 27, 1986, the night before the space shuttle
#' *Challenger* exploded, an engineer recommended to the National
#' Aeronautics and Space Administration (NASA) that the shuttle not be
#' launched in the cold weather.  The forecasted temperature for the
#' *Challenger* launch was 31 degrees Fahrenheit---the coldest
#' launch ever.  After an intense 3-hour telephone conference, officials
#' decided to proceed with the launch.  This data frame contains the
#' launch temperatures and the number of O-ring problems in 24 shuttle
#' launches prior to the *Challenger*. (This documentation comes from the `Sleuth3` package,
#' where the dataset is called `ex2223`.)
#'
#' @docType data
#'
#' @usage data(Orings)
#'
#' @format A data frame with 24 observations on the following 2 variables.
#' - temp Launch temperatures (in degrees Fahrenheit)
#' - incidents Numbers of O-ring incidents
#'
#' @source
#' Ramsey, F.L. and Schafer, D.W. (2013). *The Statistical Sleuth: A
#'    Course in Methods of Data Analysis (3rd ed)*, Cengage Learning.
#'
#' @keywords datasets
"Orings"
