% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_matrix_functions.R
\name{predict.LaMa_matrices}
\alias{predict.LaMa_matrices}
\title{Build the prediction design matrix based on new data and model_matrices object created by \code{\link{make_matrices}}}
\usage{
\method{predict}{LaMa_matrices}(object, ...)
}
\arguments{
\item{object}{model matrices object as returned from \code{\link{make_matrices}}}

\item{...}{needs to be a \code{newdata} data frame containing the variables in the formula and new data for which to evaluate the basis}
}
\value{
prediction design matrix for \code{newdata} with the same basis as used for \code{model_matrices}
}
\description{
Build the prediction design matrix based on new data and model_matrices object created by \code{\link{make_matrices}}
}
\examples{
modmat = make_matrices(~ s(x), data.frame(x = 1:10))
Z_predict = predict(modmat, data.frame(x = 1:10 - 0.5))
}
