% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LibOPF.R
\name{opf_knn_classify}
\alias{opf_knn_classify}
\title{Executes the test phase of the OPF classifier with knn adjacency}
\usage{
opf_knn_classify(dataSet, classifier, precomputedDistance = NA)
}
\arguments{
\item{dataSet}{The testing object produced by the opf_split (subGraph object)}

\item{classifier}{The classifier object produced by one of the classification functions (model object)}

\item{precomputedDistance}{The precomputed distance matrix produced by the opf_distance (leave it in blank if you are not using this resource)}
}
\value{
Returns the given subGraph classification list
}
\description{
Executes the test phase of the OPF classifier with knn adjacency
}
\examples{
dat <- opf_read_subGraph(system.file("extdata/boat.dat",package = "LibOPF"))
X <- opf_split(dat,0.8,0,0.2,0)
T <- X$training
T2 <- X$testing
Y <- opf_cluster(T,100,1,0.2)
class <- opf_knn_classify(T2, Y$classifier)
acc <- opf_accuracy(T2, class)

}
