% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_markers.R
\name{lm_markers}
\alias{lm_markers}
\title{add a "markers" layer to a lifemap_obj object.}
\usage{
lm_markers(
  data = NULL,
  radius = 10,
  min = 10,
  max = 40,
  fillColor = NULL,
  var_fillColor = NULL,
  fillOpacity = 0.8,
  stroke = FALSE,
  color = NULL,
  var_color = NULL,
  weight = 1,
  opacity = 0.8,
  legend = TRUE,
  legendPosition = c("topright", "bottomright", "bottomleft", "topleft"),
  legendOrientation = c("vertical", "horizontal"),
  legendOpacity = 0.5,
  FUN = NULL,
  display = c("auto", "requested", "all", "leaves"),
  popup = NULL,
  label = NULL
)
}
\arguments{
\item{data}{A sub dataset to use, if NULL then all of the taxids from the lifemap object given to lifemap() will be used.}

\item{radius}{Either a numerical value or a column name of the original dataframe to represent this variable by the size of markers.}

\item{min}{An integer indicating the minimal size of the markers if radius is a column name.}

\item{max}{An integer indicating the maximal size of the markers if radius is a column name.}

\item{fillColor}{Either a color or a palette if the fillColor is represented by a variable.}

\item{var_fillColor}{A column name of the original dataframe to represent this variable by the fillColor of markers.}

\item{fillOpacity}{A numeric indicating the fill opacity.}

\item{stroke}{A logical indicating whether to draw a border for markers.}

\item{color}{The stroke color. Either a color or a palette if the stroke color is represented by a variable.}

\item{var_color}{A column name of the original dataframe to represent this variable by the stroke color.}

\item{weight}{The stroke width in pixels.}

\item{opacity}{The stroke opacity.}

\item{legend}{Whether to display the legend or not.}

\item{legendPosition}{c("topright", "bottomright", "bottomleft", "topleft").}

\item{legendOrientation}{c("vertical", "horizontal").}

\item{legendOpacity}{Legend opacity (applies on the shapes in the legend, not the background itself).}

\item{FUN}{The function to be applied to infer values. If NULL then the information missing from the parent nodes won't be inferred.}

\item{display}{c("auto", "requested", "all", "leaves"), a string indicating how to display markers :
\itemize{
\item "auto" : the markers are displayed depending on the zoom level, by default, allow to have a lot of markers
\item "requested" : only displays the requested taxa, but all at the same time
\item "all" : displays all the taxa including all the ancestors to the root
\item "leaves" : displays only the latest (most recent) taxa
}

(WARNING : "requested", "leaves" and "auto" shouldn't be used to display more than 2000 markers as it may result in long computing time).}

\item{popup}{A column name indicating what to display when clicking on a node.}

\item{label}{A column name indicating what to display when hovering on a node.}
}
\value{
An lm_markers object containing all aesthetics details for one layer of markers.
}
\description{
Adds a layer with circles that can represent data. The main parameters that can be used to represent data are the following:
\itemize{
\item radius
\item var_fillColor
\item var_color (stroke's color)
}
}
\examples{
data(LM_eukaryotes)

lm_markers(data = LM_eukaryotes$df[LM_eukaryotes$df$Group \%in\% "Plants", ])

lm_markers(radius = "GC.", var_fillColor = "Genes")

}
