% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_numeric.R
\name{summarize_numeric}
\alias{summarize_numeric}
\alias{summarise_numeric}
\title{Summarize numeric columns in dataframes to means}
\usage{
summarize_numeric(
  data,
  remove = NULL,
  prefix = "mean_",
  na.rm = TRUE,
  complete.groups.on = NULL,
  add.total.duration = TRUE,
  durations.dec = 0,
  Datetime2Time = TRUE
)

summarise_numeric(
  data,
  remove = NULL,
  prefix = "mean_",
  na.rm = TRUE,
  complete.groups.on = NULL,
  add.total.duration = TRUE,
  durations.dec = 0,
  Datetime2Time = TRUE
)
}
\arguments{
\item{data}{A dataframe containing numeric data, typically from
\code{\link[=extract_clusters]{extract_clusters()}} or \code{\link[=extract_gaps]{extract_gaps()}}.}

\item{remove}{Character vector of columns removed from the summary.}

\item{prefix}{A prefix to add to the column names of summarized metrics.
Defaults to "mean_".}

\item{na.rm}{Whether to remove NA values when calculating means. Defaults to
TRUE.}

\item{complete.groups.on}{Column name that, together with grouping variables,
can be used to provide a complete set. For example, with
\code{\link[=extract_clusters]{extract_clusters()}}, some days might not have clusters. They do not show
up in the summary output then. If it is important however, to consider that
there are zero instances, one could extract the complete set of clusters
and non-clusters, and then set \code{is.cluster} in this argument, which would
then show zero clusters for those days.}

\item{add.total.duration}{Logical, whether the total duration for a given
group should be calculated. Only relevant if a column \code{duration} is part of
the input data.}

\item{durations.dec}{Numeric of number of decimals for the mean calculation
of durations and times. Defaults to 0.}

\item{Datetime2Time}{Logical of whether POSIXct columns should be transformed
into hms(time) columns, which is usually sensible for averaging (default is
\code{TRUE}). Calls \code{\link[=Datetime2Time]{Datetime2Time()}} with default settings (all POSIXct are
affected).}
}
\value{
A dataframe containing the summarized metrics.
}
\description{
This simple helper function was created to summarize episodes of
gaps, clusters, or states, focusing on numeric variables. It calculates
mean values for all numeric columns and handles Duration objects
appropriately.

Despite its name, the function actually summarizes all double columns,
which is more inclusive compared to just numeric columns.
}
\examples{
# Extract clusters and summarize them
dataset <-
sample.data.environment \%>\%
aggregate_Datetime(unit = "15 mins") |>
extract_clusters(MEDI > 1000)

#input to summarize_numeric
dataset |> utils::head()
#output of summarize_numeric (removing state.count and epoch from the summary)
dataset |> summarize_numeric(c("state.count", "epoch"))
}
