% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/LinkedMatrix.R
\docType{methods}
\name{summary,LinkedMatrix-method}
\alias{summary,LinkedMatrix-method}
\title{Summary function for \code{\linkS4class{ColumnLinkedMatrix}} or
\code{\linkS4class{RowLinkedMatrix}} objects.}
\usage{
\S4method{summary}{LinkedMatrix}(object, MARGIN = 2, chunkSize = 1000, ...)
}
\arguments{
\item{object}{Either a \code{\linkS4class{ColumnLinkedMatrix}} or a
\code{\linkS4class{RowLinkedMatrix}} object.}

\item{MARGIN}{Use 1 to obtain row summaries or 2 to obtain column summaries.}

\item{chunkSize}{The number of rows or columns that are processed at a time
(see Details).}

\item{...}{Optional arguments to summary functions.}
}
\value{
Returns a \code{matrix} of summaries.
}
\description{
This function brings chunks (of size \code{chunkSize}) of rows (if
\code{MARGIN} is 1) or columns (if \code{MARGIN} is 2) of the
\code{LinkedMatrix} instance into RAM as \code{matrix} objects and calls an
appropriate summary function based on the type of the matrix for each chunk.
Results from all the chunks are collected and returned.
}

