% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataProcessing.R
\name{dataProcessing}
\alias{dataProcessing}
\title{Process mzXML files individually: peakpicking and isotope annotation}
\usage{
dataProcessing(
  file,
  acquisitionmode,
  polarity,
  dmzagglom = 15,
  drtagglom = 500,
  drtclust = 100,
  minpeak = c(5, 3),
  drtgap = 10,
  drtminpeak = c(15, 15),
  drtmaxpeak = c(100, 200),
  recurs = 5,
  sb = c(3, 2),
  sn = 2,
  minint = c(1000, 100),
  weight = c(2, 3),
  dmzIso = 5,
  drtIso = 5
)
}
\arguments{
\item{file}{file path.}

\item{acquisitionmode}{character value: MS, DIA or DDA.}

\item{polarity}{character value: negative or positive.}

\item{dmzagglom}{mz tolerance (in ppm) used for partitioning and clustering.}

\item{drtagglom}{RT window used for partitioning (in seconds).}

\item{drtclust}{RT window used for clustering (in seconds).}

\item{minpeak}{minimum number of measurements required for a peak.}

\item{drtgap}{maximum RT gap length to be filled (in seconds).}

\item{drtminpeak}{minimum RT width of a peak (in seconds). At least minpeak 
within the drtminpeak window are required to define a peak.}

\item{drtmaxpeak}{maximum RT width of a single peak (in seconds).}

\item{recurs}{maximum number of peaks within one EIC.}

\item{sb}{signal-to-base ratio.}

\item{sn}{signal-to-noise ratio.}

\item{minint}{minimum intensity of a peak.}

\item{weight}{weight for assigning measurements to a peak.}

\item{dmzIso}{mass tolerance for isotope matching.}

\item{drtIso}{time window for isotope matching.}
}
\value{
an msobject that contains metadata of the mzXML file, raw data and
extracted peaks.
}
\description{
Process mzXML files individually: peakpicking and isotope anotation
}
\details{
This function executes 2 steps: 1) peak-picking based on enviPick
package and 2) isotope annotation.

Numeric arguments accept one or two values for MS1 and MS2, respectively.
}
\examples{
\dontrun{
msobject <- dataProcessing("input_file.mzXML", acquisitionmode="DIA", polarity,
dmzagglom = 25, drtagglom = 500, drtclust = 60, minpeak = c(5, 3),
drtgap = 5, drtminpeak = 20, drtmaxpeak = 100, recurs = 5, sb = c(3, 2),
sn = 2, minint = c(1000, 100), weight = 2, dmzIso = 10, drtIso = 5)
}

}
\references{
Peak-picking algorithm has been imported from enviPick R-package:
https://cran.r-project.org/web/packages/enviPick/index.html
}
\seealso{
\link{batchdataProcessing} and \link{setmsbatch}
}
\author{
M Isabel Alcoriza-Balaguer <maialba@iislafe.es>
}
