% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localControl.R
\name{localControlCompetingRisksConfidence}
\alias{localControlCompetingRisksConfidence}
\title{Calculate confidence intervals around the cumulative incidence functions (CIFs) generated by localControlCompetingRisks.}
\usage{
localControlCompetingRisksConfidence(LCCompRisk, confLevel = "95\%",
  confTransform = "asin")
}
\arguments{
\item{LCCompRisk}{Output from a successful call to localControlCompetingRisks}

\item{confLevel}{Level of confidence with which the confidence intervals will be formed. Choices are: "90\%", "95\%", "98\%", "99\%".}

\item{confTransform}{Transformation of the confidence intervals, defaults to arcsin ("asin"). 
"log" and "linear" are also implemented.}
}
\description{
Given the output of \code{\link{localControlCompetingRisks}}, this function produces pointwise standard error estimates 
for the cumulative incidence functions (CIFs) using a modified version of Choudhury's approach (2002). This function currently supports 
the creation of 90\%, 95\%, 98\%, and 99\% confidence intervals with linear, log(-log), and arcsine transformations of the estimates.
}
\examples{
 data(cardSim)
 results = localControlCompetingRisks(data = cardSim, 
                                      outcomeColName = "status", 
                                      timeColName = "time", 
                                      treatmentColName = "drug", 
                                      treatmentCode = 1,
                                      clusterVars = c("age", "bmi"))

 conf = localControlCompetingRisksConfidence(results)
                                      
}
\references{
Choudhury JB (2002) Non-parametric confidence interval estimation for competing risks analysis: application to contraceptive data. 
Stat Med 21:1129-1144. doi: 10.1002/sim.1070
}
