% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localControl.R
\name{LocalControl}
\alias{LocalControl}
\title{Local Control}
\usage{
LocalControl(data, modelForm = NULL, outcomeType = "cross-sectional",
  treatmentColName, outcomeColName, cenCode = 0, clusterVars,
  timeColName = "", treatmentCode, labelColName = "", radStepType = "exp",
  radDecayRate = 0.8, radMinFract = 0.01, radiusLevels = numeric(),
  normalize = TRUE, verbose = FALSE, numThreads = 1)
}
\arguments{
\item{data}{DataFrame containing all variables which will be used for the analysis.}

\item{modelForm}{A formula containing the necessary variables for Local Control analysis. This can be used as an alternative
to the primary interface for cross-sectional studies. The formula should be in the following format:
"outcome ~ treatment | clusterVar1 ... clusterVarN".}

\item{outcomeType}{Specifys the outcome type for the analysis. Defaults to cross-sectional.}

\item{treatmentColName}{A string containing the name of a column in data.
The column contains the treatment variable specifying the treatment groups.}

\item{outcomeColName}{A string containing the name of a column in data.
The column contains the outcome variable to be compared between the treatment groups.}

\item{cenCode}{A value specifying which of the outcome values corresponds to a censored observation.}

\item{clusterVars}{A character vector containing column names in data.
Each column contains an X-variable, or covariate which will be used to form patient clusters.}

\item{timeColName}{A string containing the name of a column in data.
The column contains the time to outcome for each of the observations in data.}

\item{treatmentCode}{(optional) A string containing one of the factor levels from the treatment column.
If provided, the corresponding treatment will be considered "Treatment 1".
Otherwise, the first "level" of the column will be considered the primary treatment.}

\item{labelColName}{(optional) A string containing the name of a column from data.
The column contains labels for each of the observations in data, defaults to the row indices.}

\item{radStepType}{(optional) Used in the generation of correction radii.
The step type used to generate each correction radius after the maximum.
Currently accepts "unif" and "exp" (default).
"unif" for uniform decay ex: (radDecayRate = 0.1) (1, 0.9, 0.8, 0.7, ..., ~minRadFract, 0)
"exp" for exponential decay ex: (radDecayRate = 0.9) (1, 0.9, 0.81, 0.729, ..., ~minRadFract, 0)}

\item{radDecayRate}{(optional) Used in the generation of correction radii.
The size of the "step" between each of the generated correction radii.
If radStepType == "exp", radDecayRate must be a value between (0,1).
This value defaults to 0.8.}

\item{radMinFract}{(optional) Used in the generation of correction radii.
A floating point number representing the smallest fraction of the maximum radius to use as a correction radius.}

\item{radiusLevels}{(optional) By default, Local Control builds a set of radii to fit data.
The radiusLevels parameter allows users to override the construction by explicitly providing a set of radii.}

\item{normalize}{(optional) Logical value. Tells local control if it should or should not normalize the covariates. Default is TRUE.}

\item{verbose}{(optional) Logical value. Display or suppress the console output during the call to Local Control. Default is FALSE.}

\item{numThreads}{(optional) An integer value specifying the number of threads which will be assigned to the analysis.
The maximum number of threads varies depending on the system hardware. Defaults to 1 thread.}
}
\value{
A list containing the results from the call to LocalControl.
\itemize{
  \item{outcomes} {List containing two dataframes for the average T1 and T0 outcomes within each cluster at each radius.}
  \item{counts} {List containing two dataframes which hold the number of T1 and T0 patients within each cluster at each radius.}
  \item{ltds} {Dataframe containing the average LTD within each cluster at each radius.}
  \item{summary} {Dataframe containing summary statistics about the analysis for each radius.}
  \item{params} {List containing the parameters used to call LocalControl.}
}
}
\description{
Implements a non-parametric methodology for correcting biases when comparing the outcomes of two treatments in a
 cross-sectional or case control observational study. This implementation of Local Control uses nearest neighbors to each point within
 a given radius to compare treatment outcomes. Local Control matches along a continuum of similarity (radii), clustering the near neighbors
 to a given observation by variables thought to be sources of bias and confounding. This is analogous to combining a host of smaller studies
 that are each homogeneous within themselves, but represent the spectrum of variability of observations across diverse subpopulations. As the
 clusters get smaller, some of them can become noninformative, whereby all cluster members contain only one treatment, and there is no basis
 for comparison. Each observation has a unique set of near-neighbors, and the approach becomes more akin to a non-parametric
 density estimate using similar observations within a covariate hypersphere of a given radius. The global treatment difference is
 taken as the average of the treatment differences of the neighborhood around each observation.

 While \code{\link{LocalControlClassic}} uses the number of clusters as a varying parameter to visualize treatment differences
 as a function of similarity of observations, this function instead uses a varying radius. The maximum radius enclosing all observations
 corresponds to the biased estimate which compares the outcome of all those with treatment A versus all those with treatment B.
 An easily interpretable graph can be created to illustrate the change in estimated outcome difference between two treatments, on average, across
 all clusters, as a function of using smaller and more homogenous clusters. The \code{\link{LocalControlNearestNeighborsConfidence}} procedure
 statistically resamples this Local Control process to generate confidence estimates.
 It is also helpful to plot a box-plot of the local treatment difference at a radius of zero, requiring that every observation has at
 least one perfect match on the other treatment. When perfect matches exist, one can estimate the treatment difference without making
 assumptions about the relative importance of the clustering variables. The \code{\link{plot.LocalControlCS}} function will plot both
 visualizations in a single graph.
}
\examples{
 # cross-sectional

 data(lindner)
 linVars <- c("stent", "height", "female", "diabetic", "acutemi",
              "ejecfrac", "ves1proc")
 csresults = LocalControl(data = lindner,
                          clusterVars = linVars,
                          treatmentColName = "abcix",
                          outcomeColName = "cardbill",
                          treatmentCode = 1)
 plot(csresults)


 # survival / competing risks example

 data(cardSim)
 crresults = LocalControl(data = cardSim, outcomeType = "survival",
                          outcomeColName = "status",
                          timeColName = "time",
                          treatmentColName = "drug",
                          treatmentCode = 1,
                          clusterVars = c("age", "bmi"))
 plot(crresults)
}
\references{
\itemize{
   \item Fischer K, Gartner B, Kutz M. Fast Smallest-Enclosing-Ball Computation in High Dimensions. In: Algorithms - ESA 2003. Springer, Berlin, Heidelberg; 2003:630-641.
   \item Martin Kutz, Kaspar Fischer, Bernd Gartner. miniball-1.0.3. \url{https://github.com/hbf/miniball}.
}
}
