'QCAtt2LOtt' <- function(qcatt)
########################################################################
#' @title Create logicopt tt from QCA tt
#'
#' @description This function takes a truth table produced by the package 
#' QCAGUI (or QCApro) function truthTable() and creates an logicopt() format 
#' truth table.
#
#' @return truth table for logicopt() 
#
#' @param qcatt 
#' An R data frame table generated by QCAGUI or QCApro truthTable(). 
#'
#' @examples
#' \dontrun{
#' inpath <- system.file("extdata/raw_qca/partybans.csv", package="LogicOpt")
#' partybans <- read.csv(inpath,row.names=1,na="")
#' library(QCAGUI)  
#' q.partybans.1 <- truthTable(partybans, conditions = c("C","F","T","R","V"), outcome = "PB{1}")
#' l.partybans.1 <- QCAtt2LOtt(q.partybans.1)
#' }
#' @export
############################################################################
########################################################################
{
    # get input_sizes 
    input_sizes <- qcatt$noflevels
    n_in = length(input_sizes)
    if (n_in == 0)
       stop('Input sizes not found in qcatt.\n')

    # get outcome
    outcome <- qcatt$options$outcome
    if (length(outcome) == 0)
       outcome <- qcatt$outcome

    # get input columns and output column and strip the rest
    qcatt <- qcatt$tt[, seq(n_in+1)]

    # strip off don't cares and let espressso() compute with find_dc=TRUE
    qcatt <- qcatt[qcatt$OUT != "?",]

    # rename output to outcome name
    if (length(outcome) > 0)
       colnames(qcatt)[n_in+1] <- outcome 

    # move contradictions to offset 
    cees <- qcatt[outcome] == "C"
    qcatt[cees,outcome] <- 0

    return(as.data.frame(qcatt))
}
