% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sig.R
\name{sig}
\alias{sig}
\alias{sig.glm}
\title{Significance tests for a
binary regression models fit with \code{glm}}
\usage{
sig(x, ...)

\method{sig}{glm}(x, ..., test = c("var", "coef"))
}
\arguments{
\item{x}{A regression model with class \code{glm} and
\code{x$family$family == "binomial"}.}

\item{...}{Not used.}

\item{test}{What to test.
\itemize{
 \item If \code{test="var"} (the default),
       will test significance for
       each \emph{variable} in the model.
       \cr
       This includes the intercept, if present.
       \cr
       This means \code{factor}s are tested for
       \emph{all} \code{level}s simultaneously.
 \item If \code{test="coef"}, will test
       significance for each \emph{coefficient} in the model.
       \cr
       This means the 'dummy variables' created from
       \code{factor}s will be tested individually.
}}
}
\value{
A \code{list} of \code{data.table}s as follows:

\item{Wald}{The Wald test for each coefficient which is:
  \deqn{W = \frac{\hat{\beta}}{\hat{SE_{\beta}}}}{
        W = B / SE[B]}
  This should be normally distributed.}
\item{LR}{The \bold{l}ikelihood \bold{r}atio test
  for each coefficient:
  \deqn{LR = -2 \log{\frac{\mathrm{likelihood \phantom{+} without \phantom{+} variable}}{
                           \mathrm{likelihood \phantom{+} with \phantom{+} variable}}}}{
        LR = -2 * log(likelihood without / likelihood with variable)}
  which is:
  \deqn{LR = -2 \sum_{i=1}^n(y_i \log{\frac{P_i}{y_i}} +
           (1 - y_i) \log{\frac{1 - P_i}{1-y_i}})}{
        LR = -2 * SUM(y * log(P / y) +
           (1 - y) * log((1 - P) / (1 - y)))}
When comparing a fitted model to a saturated model
(i.e. \eqn{P_i = y_i}{P[i]=y[i]} and likelihood \eqn{=1}),
the \eqn{LR} is referred to as the model \emph{deviance},
\eqn{D}.
}

\item{score}{The score test, also known as the
  Rao, Cochran-Armitage trend and the Lagrange multiplier test.
  \cr
  This removes a variable from the model, then assesses
  the change. For logistic regression this is based on:
   \deqn{\bar{y} = \frac{\sum_{i=1}^n y_i}{n}}{
         ybar = (SUM y[i]) / n}
  and
   \deqn{\bar{x} = \frac{\sum_{i=1}^n x_i n_i}{n}}{
         xbar = (SUM x[i] * n[i]) / n}
  The statistic is:
   \deqn{\mathrm{ST} = \frac{\sum_{i=1}^n y_i(x_i - \bar{x})}{
                          \sqrt{\bar{y}(1-\bar{y})\sum_{i=1}^n (x_i-\bar{x}^2)}}}{
         ST = SUM x[i](y[i] - ybar) / (ybar(1 - ybar) SUM (x[i] - xbar)^2)^0.5}
 If the value of the coefficient is correct, the test should follow
 a standard normal distribution.
}
}
\description{
Significance tests for a
binary regression models fit with \code{glm}
}
\note{
The result has the \code{class} \code{"sig.glm"}.
The \code{print} method for this \code{class} shows only
the model coefficients and \eqn{p} values.
}
\examples{
data(ageChd)
## H&L 2nd ed. Table 1.3. Page 10.
summary(g1 <- glm(chd ~ age, data=ageChd, family=binomial))
sig(g1)
data(lbw)
## Table 2.2. Page 36.
summary(g2 <- glm(LOW ~ AGE + LWT + RACE + FTV,
                  data=lbw, family=binomial))
sig(g2)
## Table 2.3. Pages 38-39.
summary(g3 <- glm(LOW ~ LWT + RACE,
                  data=lbw, family=binomial))
sig(g3, test="coef")
## RACE is more significant when dropped as a factor
## 
sig(g3, test="var")
}
\seealso{
?aod::wald.test
\cr
?statmod::glm.scoretest
\cr
For corrected score tests:
\cr
?mdscore::mdscore
}
