% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pre_assumption.R
\name{auto_signif_test}
\alias{auto_signif_test}
\title{Automatically significance testing}
\usage{
auto_signif_test(
  data,
  treatment_col,
  value_col,
  paired,
  subject_col,
  prior = FALSE,
  comparison_method = NULL,
  equally_rep = TRUE,
  output = "console",
  output_dir = "./",
  filename = "auto_signif_test",
  report = TRUE
)
}
\arguments{
\item{data}{Data frame containing the treatment, value and other information.}

\item{treatment_col}{Numeric indicating where treatment locates (column number) in data.}

\item{value_col}{Numeric indicating where treatment value (column number) in data.}

\item{paired}{Logical indicating whether you want a paired t-test.}

\item{subject_col}{Only meaningful when Pair is ture. Numeric indicating where subject of treatment (column number) in data.}

\item{prior}{logical. Whether conducted prior comparisons.}

\item{comparison_method}{Character string. Only use for more than 2 treatment. Default would automatically choose method. Method of multiple comparison,must be one of "SNK", "Tukey", "bonferroni","LSD" or "Scheffe".}

\item{equally_rep}{Logical indicating Whether all treatments have same number of replication.}

\item{output}{A character string indicating output style. Default: "console", which print the report in console. And "file" is available to output report into text-file.}

\item{output_dir}{Default:"./". Available only when output="file". The direction of output file.}

\item{filename}{A character string indicating file name of output file. Only work when output set as 'file'.}

\item{report}{Logical. If print report to console. Default:TRUE}
}
\value{
auto_signif_test returns results of significant test and print report in console or file. See details in example.

See results return in \code{\link{t_test_report}}, \code{\link{wilcox_test_report}}, \code{\link{anova_report}}, \code{\link{kruskal_report}}.
}
\description{
Automatically choose significance testing
}
\note{
1.when choose output="file", once caused error that terminate the program, use 'sink()' to end the written of exist files.

2.Please confirm your data is in format of dataframe, else may cause bug! (e.g. Do not use 'read.xlsx' to load data into tibble format)
}
\examples{
### Here shows different types of experimental design ###
data("cotton", package = "agricolae")

### Two randomly designed groups ###
sig_results <- auto_signif_test(
  data = cotton,
  treatment_col = 1,
  value_col = 5
)

### Two paired design groups ###
sig_results <- auto_signif_test(
  data = cotton,
  treatment_col = 1,
  value_col = 5,
  paired = TRUE,
  subject_col = 2
)

### More than two randomly designed groups ###
sig_results <- auto_signif_test(
  data = cotton,
  treatment_col = 2,
  value_col = 5
)
head(sig_results)  # Check outputs

### Conduct prior comparisons ###
sig_results <- auto_signif_test(
  data = cotton,
  treatment_col = 2,
  value_col = 5,
  prior = TRUE
)
head(sig_results)  # Check outputs
print(sig_results$basicdata)  # Check statistical summary
print(sig_results$anova_model)  # Extract ANOVA model
print(sig_results$anova_summary)  # Check ANOVA summary
print(sig_results$multiple_comparison_model)  # Extract multiple comparison model
print(sig_results$comparison_results)  # Check between-group comparison
print(sig_results$comparison_letters)  # Check letters (can be used in visualization)

## Change multiple comparison method (maybe not illegal!!)
sig_results <- auto_signif_test(
  data = cotton,
  treatment_col = 2,
  value_col = 5,
  prior = TRUE,
  comparison_method = "LSD"
)
head(sig_results)  # Check outputs
print(sig_results$comparison_letters)  # Note that letters become different

}
