% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_plot.R
\name{compare_plot}
\alias{compare_plot}
\title{Comparison plot generator
This function help generate comparsion plot including bar plot, box plot, and violin plot}
\usage{
compare_plot(
  inputframe,
  treat_location,
  value_location,
  aes_col = NULL,
  point = TRUE,
  facet_location = NULL,
  ylab_text = NULL
)
}
\arguments{
\item{inputframe}{A data frame contain information for visualization.}

\item{treat_location}{Numeric. Treatment column number in inputframe.}

\item{value_location}{Numeric. Value column number in inputframe.}

\item{aes_col}{Named character string, default:NULL. A set of aesthetic character to map treatment to.}

\item{point}{Logical. If draw point on bar, box and violin plot. Default:TRUE.}

\item{facet_location}{Numeric, default:NULL. Facet column number in inputframe.}

\item{ylab_text}{Character. Text for y axis.}
}
\value{
A list contained plot and statistics
}
\description{
Comparison plot generator
This function help generate comparsion plot including bar plot, box plot, and violin plot
}
\examples{
data("iris")
results=compare_plot(inputframe=iris,treat_location=5,
                     value_location=1,ylab_text = "Sepal Length")

#Check statistics
results$Statistics
#Extract plot
results$Barplot
results$Boxplot
results$Violinplot


iris$Treat2=rep(c(rep("A",25),rep("B",25)),3)

results=compare_plot(inputframe=iris,treat_location=5,
                     value_location=1,facet_location = 6,
                     ylab_text = "Sepal Length")

#Check statistics
results$Statistics
#Extract plot
results$Barplot
results$Boxplot
results$Violinplot
#Extract combined plot
results$All_Barplot
results$All_Boxplot
results$All_Violinplot

}
