% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lorenz-graphs.R
\name{Lorenz.graphs}
\alias{Lorenz.graphs}
\title{Graphs of concentration curves}
\usage{
Lorenz.graphs(formula, data, ...)
}
\arguments{
\item{formula}{A formula object of the form \emph{response} ~ \emph{other_variables}.}

\item{data}{A dataframe containing the variables of interest}

\item{...}{other arguments (see Section 'Arguments' in \code{\link{Lorenz.curve}}).}
}
\value{
A plot comprising
\itemize{
   \item The Lorenz curve of \emph{response}
   \item The concentration curves of \emph{response} with respect to each element of \emph{other_variables}
}
}
\description{
\code{Lorenz.graphs} traces the Lorenz curve of a response and the concentration curve of the response and each of a series of covariates.
}
\examples{
data(Data.Incomes)
Lorenz.graphs(Income ~ Age + Work.Hours, data = Data.Incomes)

}
\seealso{
\code{\link{Lorenz.curve}}, \code{\link{Gini.coef}}
}
