% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lowWAFOMSobol.R
\docType{package}
\name{LowWAFOMSobol-package}
\alias{LowWAFOMSobol-package}
\alias{LowWAFOMSobol}
\title{Low WAFOM Sobol Sequence}
\description{
Description: R implementation of Low Walsh Figure of Merit (WAFOM)
Sequence based on Sobol Sequence.
}
\details{
Porting to R by Mutsuo Saito.
The R version does not returns cordinate value zero,
but returns value very near to zero, 2^-64.
}
\section{Acknowledgment}{

The development of this code is partially supported
by JST CREST.
}

\section{Reference}{

* Shinsuke Mori,
  "Suuchi Sekibun no tameno QMC Ten Shuugou no Sekkei, Tansaku,
  oyobi sono Yuukousei",
  Master's Thesis, 2017,
* Ryuichi Ohori,
  "Efficient Quasi Monte Carlo Integration by Adjusting the
  Derivation-sensitivity Parameter of Walsh Figure of Merit",
  Master's Thesis, 2015.
* S. Harase and R. Ohori,
  "A search for extensible low-WAFOM point sets",
  arXiv preprint, arXiv:1309.7828, (2013),
  https://arxiv.org/abs/1309.7828.
* M. Matsumoto and R. Ohori,
  "Walsh Figure of Merit for Digital Nets: An Easy Measure
  for Higher Order Convergent QMC",
  Springer International Publishing, Cham, 2016, pp. 143-160.
* M. Matsumoto, M. Saito, and K. Matoba,
  "A computable figure of merit for quasi-Monte Carlo point sets",
  Mathematics of Computation, 83 (2014), pp. 1233-1250.
* S. Joe and F. Y. Kuo,
  "Constructing Sobol sequences with better two-dimensional projections",
  SIAM J. Sci. Comput. 30, 2635-2654 (2008).
}

\examples{
srange <- lowWAFOMSobol.dimMinMax()
mrange <- lowWAFOMSobol.dimF2MinMax(srange[1])
points <- lowWAFOMSobol.points(dimR=srange[1], dimF2=mrange[1], count=10000)
points <- lowWAFOMSobol.points(dimR=srange[1], dimF2=mrange[1], count=10000,
                            digitalShift=TRUE)
}
