% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/RLum.Analysis-class.R
\docType{class}
\name{RLum.Analysis-class}
\alias{RLum.Analysis-class}
\alias{get_RLum,RLum.Analysis-method}
\alias{length_RLum,RLum.Analysis-method}
\alias{set_RLum,RLum.Analysis-method}
\alias{structure_RLum,RLum.Analysis-method}
\title{Class \code{"RLum.Analysis"}}
\usage{
\S4method{structure_RLum}{RLum.Analysis}(object)

\S4method{set_RLum}{RLum.Analysis}(class, records, protocol)

\S4method{get_RLum}{RLum.Analysis}(object, record.id, recordType, curveType,
  RLum.type, protocol = "UNKNOWN", info.object, get.index,
  keep.object = FALSE, recursive = TRUE)

\S4method{length_RLum}{RLum.Analysis}(object)
}
\arguments{
\item{object}{[\code{structure_RLum}] an object of class \code{\linkS4class{RLum.Analysis}} (\bold{required})}

\item{class}{[\code{set_RLum}] \code{\link{character}} (\bold{required}): name of the \code{RLum} class to be created}

\item{records}{[\code{set_RLum}] \code{\link{list}} (\bold{required}): list of \code{\linkS4class{RLum.Analysis}} objects}

\item{protocol}{[\code{set_RLum}] \code{\link{character}} (optional): sets protocol type for
analysis object. Value may be used by subsequent analysis functions. \code{UNKNOWN}
by default.}

\item{record.id}{[\code{get_RLum}] \code{\link{numeric}} (optional): IDs of specific records}

\item{recordType}{[\code{get_RLum}] \code{\link{character}} (optional): record type (e.g. "OSL")}

\item{curveType}{[\code{get_RLum}] \code{\link{character}} (optional): curve type (e.g. "predefined" or "measured")}

\item{RLum.type}{[\code{get_RLum}] \code{\link{character}} (optional): RLum object type. Defaults to "RLum.Data.Curve"
and "RLum.Data.Spectrum".}

\item{info.object}{[\code{get_RLum}] currently not used.}

\item{get.index}{[\code{get_RLum}] \code{\link{logical}} (optional): return a numeric vector with the index of each
element in the RLum.Analysis object.}

\item{keep.object}{[\code{get_RLum}] \code{\link{logical}} (with default):
return an RLum.Analysis object instead of the single elements.}

\item{recursive}{[\code{get_RLum}] \code{\link{logical}} (with default): if \code{TRUE} (the default)
and the result of the 'get_RLum' request is a single object this object will be unlisted, means
only the object itself and no list containing exactly one object is returned. Mostly this makes things
easier, however, if this method in a loop this might become annoying}
}
\description{
Object class containing analysis data for protocol analysis.
}
\section{Methods (by generic)}{
\itemize{
\item \code{structure_RLum}: Method to show the structure of an \code{\linkS4class{RLum.Analysis}} object.

\item \code{set_RLum}: Construction method for \code{\linkS4class{RLum.Analysis}} objects.

\item \code{get_RLum}: Accessor method for RLum.Analysis object.

The slots record.id, recordType, curveType and RLum.type are optional to allow for records
limited by their id (list index number), their record type (e.g. recordType = "OSL")
or object type.

Example: curve type (e.g. curveType = "predefined" or curveType ="measured")

The selection of a specific RLum.type object superimposes the default selection.
Currently supported objects are: RLum.Data.Curve and RLum.Data.Spectrum

\item \code{length_RLum}: Returns the length of the object, i.e., number of stored records.
}}
\section{Slots}{

\describe{
\item{\code{records}}{Object of class "list" containing objects of class RLum.Data}

\item{\code{protocol}}{Object of class "character" describing the applied measurement protocol}
}}
\note{
The method \code{get_structure} is currently just
avaiblable for objects containing \code{\linkS4class{RLum.Data.Curve}}.
}
\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new("RLum.Analysis", ...)}.
}

\section{Class version}{
 0.2.0
}
\examples{
showClass("RLum.Analysis")

## usage of get_RLum() with returning an RLum.Analysis object
#  get_RLum(object, keep.object = TRUE)
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne
(France)
}
\seealso{
\code{\link{Risoe.BINfileData2RLum.Analysis}},
\code{\linkS4class{Risoe.BINfileData}}, \code{\linkS4class{RLum}}
}
\keyword{classes}
\keyword{methods}

