% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Luminescence-package.R
\name{ExampleData.XSYG}
\alias{ExampleData.XSYG}
\title{Example data for a SAR OSL measurement and a TL spectrum using a lexsyg
reader}
\format{\code{OSL.SARMeasurement}: SAR OSL measurement data

The data contain two elements: (a) \code{$Sequence.Header} is a
\link{data.frame} with metadata from the measurement,(b)
\code{Sequence.Object} contains an \code{\linkS4class{RLum.Analysis}} object
for further analysis.\cr

\code{TL.Spectrum}: TL spectrum data

\code{\linkS4class{RLum.Data.Spectrum}} object for further analysis. The
spectrum was cleaned from cosmic-rays using the function
\code{apply_CosmicRayRemoval}. Note that no quantum efficiency calibration
was performed.}
\source{
\bold{OSL.SARMeasurement}

\tabular{ll}{

Lab: \tab Luminescence Laboratory Giessen\cr Lab-Code: \tab no code\cr
Location: \tab not specified\cr Material: \tab Coarse grain quartz \cr \tab
on steel cups on lexsyg research reader\cr Reference: \tab unpublished }

\bold{TL.Spectrum}

\tabular{ll}{

Lab: \tab Luminescence Laboratory Giessen\cr Lab-Code: \tab BT753\cr
Location: \tab Dolni Vestonice/Czech Republic\cr Material: \tab Fine grain
polymineral \cr \tab on steel cups on lexsyg rearch reader\cr Reference:
\tab Fuchs et al., 2013 \cr Spectrum: \tab Integration time 19 s, channel
time 20 s\cr Heating: \tab 1 K/s, up to 500 deg. C }
}
\description{
Example data from a SAR OSL measurement and a TL spectrum for package
Luminescence imported from a Freiberg Instruments XSYG file using the
function \code{\link{read_XSYG2R}}.
}
\section{Version}{
 0.1
}
\examples{

##show data
data(ExampleData.XSYG, envir = environment())

## =========================================
##(1) OSL.SARMeasurement
OSL.SARMeasurement

##show $Sequence.Object
OSL.SARMeasurement$Sequence.Object

##grep OSL curves and plot the first curve
OSLcurve <- get_RLum(OSL.SARMeasurement$Sequence.Object,
recordType="OSL")[[1]]
plot_RLum(OSLcurve)

## =========================================
##(2) TL.Spectrum
TL.Spectrum

##plot simple spectrum (2D)
plot_RLum.Data.Spectrum(TL.Spectrum,
                        plot.type="contour",
                        xlim = c(310,750),
                        ylim = c(0,300),
                        bin.rows=10,
                        bin.cols = 1)

##plot 3d spectrum (uncomment for usage)
# plot_RLum.Data.Spectrum(TL.Spectrum, plot.type="persp",
# xlim = c(310,750), ylim = c(0,300), bin.rows=10,
# bin.cols = 1)

}
\references{
Unpublished data measured to serve as example data for that
package. Location origin of sample BT753 is given here:

Fuchs, M., Kreutzer, S., Rousseau, D.D., Antoine, P., Hatte, C., Lagroix,
F., Moine, O., Gauthier, C., Svoboda, J., Lisa, L., 2013. The loess sequence
of Dolni Vestonice, Czech Republic: A new OSL-based chronology of the Last
Climatic Cycle. Boreas, 42, 664--677.
}
\seealso{
\code{\link{read_XSYG2R}}, \code{\linkS4class{RLum.Analysis}},\cr
\code{\linkS4class{RLum.Data.Spectrum}}, \code{\link{plot_RLum}},\cr
\code{\link{plot_RLum.Analysis}}, \code{\link{plot_RLum.Data.Spectrum}}
}
\keyword{datasets}

