% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_CosmicRayRemoval.R
\name{apply_CosmicRayRemoval}
\alias{apply_CosmicRayRemoval}
\title{Function to remove cosmic rays from an RLum.Data.Spectrum S4 class object}
\usage{
apply_CosmicRayRemoval(object, method = "smooth", method.Pych.smoothing = 2,
  method.Pych.threshold_factor = 3, MARGIN = 2, verbose = FALSE,
  plot = FALSE, ...)
}
\arguments{
\item{object}{\code{\linkS4class{RLum.Data.Spectrum}} (\bold{required}): S4
object of class \code{RLum.Data.Spectrum}}

\item{method}{\code{\link{character}} (with default): Defines method that is
applied for cosmic ray removal. Allowed methods are \code{smooth}, the default,
(\code{\link{smooth}}), \code{smooth.spline} (\code{\link{smooth.spline}})
and \code{Pych}. See details for further information.}

\item{method.Pych.smoothing}{\code{\link{integer}} (with default): Smoothing
parameter for cosmic ray removal according to Pych (2003). The value defines
how many neighboring values in each frame are used for smoothing (e.g.,
\code{2} means that the two previous and two following values are used).}

\item{method.Pych.threshold_factor}{\code{\link{numeric}} (with default): Threshold
for zero-bins in the histogram. Small values mean that more peaks are removed, but signal
might be also affected by this removal.}

\item{MARGIN}{\code{\link{integer}} (with default): on which part the function cosmic ray removal
should be applied on: 1 = along the time axis (line by line), 2 = along the wavelength axis (column by
column). Note: This argument currently only affects the methods \code{smooth} and \code{smooth.spline}}

\item{verbose}{\code{\link{logical}} (with default): Option to suppress
terminal output.,}

\item{plot}{\code{\link{logical}} (with default): If \code{TRUE} the
histograms used for the cosmic-ray removal are returned as plot including
the used threshold. Note: A separat plot is returned for each frame!
Currently only for \code{method = "Pych"} a graphical output is provided.}

\item{\dots}{further arguments and graphical parameters that will be passed
to the \code{smooth} function.}
}
\value{
Returns same object as input
(\code{\linkS4class{RLum.Data.Spectrum}})
}
\description{
The function provides several methods for cosmic ray removal and spectrum
smoothing for an RLum.Data.Spectrum S4 class object
}
\details{
\bold{\code{method = "Pych"}} \cr

This method applies the cosmic-ray removal algorithm described by Pych
(2003). Some aspects that are different to the publication: \itemize{
\item For interpolation between neighbouring values the median and not the
mean is used. \item The number of breaks to construct the histogram is set
to: \code{length(number.of.input.values)/2} } For further details see
references below.

\bold{\code{method = "smooth"}} \cr

Method uses the function \code{\link{smooth}} to remove cosmic rays.\cr

Arguments that can be passed are: \code{kind}, \code{twiceit}\cr

\bold{\code{method = "smooth.spline"}} \cr Method uses the function
\code{\link{smooth.spline}} to remove cosmic rays.\cr Arguments that can be
passed are: \code{spar}\cr

\bold{How to combine methods?}\cr

Different methods can be combined by applying the method repeatedly to the
dataset (see example).
}
\note{
-
}
\section{Function version}{
 0.2.1 (2016-05-02 09:36:06)
}

\examples{


##(1) - use with your own data and combine (uncomment for usage)
## run two times the default method and smooth with another method
## your.spectrum <- apply_CosmicRayRemoval(your.spectrum, method = "Pych")
## your.spectrum <- apply_CosmicRayRemoval(your.spectrum, method = "Pych")
## your.spectrum <- apply_CosmicRayRemoval(your.spectrum, method = "smooth")

} 

\section{How to cite}{
Kreutzer, S. (2017). apply_CosmicRayRemoval(): Function to remove cosmic rays from an RLum.Data.Spectrum S4 class object. Function version 0.2.1. In: Kreutzer, S., Dietze, M., Burow, C., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J. (2017). Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.7.1. https://CRAN.R-project.org/package=Luminescence
}

\references{
Pych, W., 2003. A Fast Algorithm for Cosmic-Ray Removal from
Single Images. Astrophysics 116, 148-153.
\url{http://arxiv.org/pdf/astro-ph/0311290.pdf?origin=publication_detail}
}
\seealso{
\code{\linkS4class{RLum.Data.Spectrum}}, \code{\link{smooth}},
\code{\link{smooth.spline}}, \code{\link{apply_CosmicRayRemoval}}
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne
(France)
\cr R Luminescence Package Team}
\keyword{manip}
