% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_De_Dr.R
\name{combine_De_Dr}
\alias{combine_De_Dr}
\title{Combine Dose Rate and Equivalent Dose Distribution}
\usage{
combine_De_Dr(
  De,
  s,
  Dr,
  int_OD,
  Age_range = c(1, 300),
  outlier_threshold = 0.05,
  outlier_method = "default",
  outlier_analysis_plot = FALSE,
  method_control = list(),
  par_local = TRUE,
  verbose = TRUE,
  plot = TRUE,
  ...
)
}
\arguments{
\item{De}{\link{numeric} (\strong{required}): a equivalent dose sample}

\item{s}{\link{numeric} (\strong{required}): a vector of measurement errors on the equivalent dose}

\item{Dr}{\link{numeric} (\strong{required}): a dose rate sample}

\item{int_OD}{\link{numeric} (\strong{required}): the intrinsic overdispersion, typically the standard deviation
characterizing a dose-recovery test distribution}

\item{Age_range}{\link{numeric} (\emph{with default}): the age range to be investigated by the algorithm, the larger
the value the more iterations are needed and the longer it takes. Should not be set too narrow, cut
the algorithm some slack.}

\item{outlier_threshold}{\link{numeric} (\emph{with default}): the required significance level used
for the outlier detection. If set to \code{1}, no outliers are removed. If
\code{outlier_method = "RousseeuwCroux1993"}, the median distance is used as outlier threshold.
Please see details for further information.}

\item{outlier_method}{\link{character} (\emph{with default}): select the outlier detection
method, either \code{"default"} or \code{"RousseeuwCroux1993"}. See details for further information.}

\item{outlier_analysis_plot}{\link{logical} (\emph{with default}): enables/disables the outlier analysis plot. Note: the outlier analysis will happen with or without plot output}

\item{method_control}{\link{list} (\emph{with default}): named \link{list} of further parameters passed down
to the \link[rjags:rjags-package]{rjags::rjags} modelling}

\item{par_local}{\link{logical} (\emph{with default}): if set to \code{TRUE} the function uses its
own \link[graphics:par]{graphics::par} settings (which will end in two plots next to each other)}

\item{verbose}{\link{logical} (\emph{with default}): enable/disable terminal feedback}

\item{plot}{\link{logical} (\emph{with default}): enable/disable plot output}

\item{...}{a few further arguments to fine-tune the plot output such as
\code{cdf_ADr_quantiles} (\code{TRUE}/\code{FALSE}), \code{legend.pos}, \code{legend} (\code{TRUE}/\code{FALSE})}
}
\value{
The function returns a plot if \code{plot = TRUE} and an \linkS4class{RLum.Results}
object with the following slots:

\verb{@data}\cr
\code{.. $Ages}: a \link{numeric} vector with the modelled ages to be further analysed or visualised\cr
\code{.. $Ages_stats}: a \link{data.frame} with sum HPD, CI 68\% and CI 95\% for the ages \cr
\code{.. $outliers_index}: the index with the detected outliers\cr
\code{.. $cdf_ADr_mean} : empirical cumulative density distribution A * Dr (mean)\cr
\code{.. $cdf_ADr_quantiles} : empirical cumulative density distribution A * Dr (quantiles .025,.975)\cr
\code{.. $cdf_De_no_outlier} : empirical cumulative density distribution of the De with no outliers\cr
\code{.. $cdf_De_initial} : empirical cumulative density distribution of the initial De\cr
\code{.. $mcmc_IAM} : the MCMC list of the Individual Age Model, only of \code{method_control = list(return_mcmc = TRUE)} otherwise \code{NULL}\cr
\code{.. $mcmc_BCAM} : the MCMC list of the Bayesian Central Age Model, only of \code{method_control = list(return_mcmc = TRUE)} otherwise \code{NULL}\cr

\verb{@info}\cr
\code{.. $call}: the original function call\cr
\code{.. $model_IAM}: the BUGS model used to derive the individual age\cr
\code{.. $model_BCAM}: the BUGS model used to calculate the Bayesian Central Age\cr
}
\description{
A Bayesian statistical analysis of OSL age requiring dose rate sample.
Estimation contains a preliminary step for detecting outliers in the equivalent
dose sample.
}
\details{
\strong{Outlier detection}

Two different outlier detection methods are implemented (full details are given
in the cited literature).
\enumerate{
\item The \emph{default} and recommend method, uses quantiles to compare prior and
posterior distributions of the individual variances of the equivalent doses.
If the corresponding quantile in the corresponding posterior distribution is larger
than the quantile in the prior distribution, the value is marked
as outlier (cf. Galharret et al., preprint)
\item The alternative method employs the method suggested by Rousseeuw and Croux (1993)
using the absolute median distance.
}

\strong{Parameters available for \code{method_control}}

The parameters listed below are used to granular control Bayesian modelling using
\link[rjags:rjags-package]{rjags::rjags}. Internally the functions \code{.calc_IndividualAgeModel()} and
\code{.calc_BayesianCentraAgelModel()}. The parameter settings affect both models.
Note: \code{method_control} expects a \strong{named} list of parameters

\tabular{llll}{
\strong{PARAMETER} \tab \strong{TYPE} \tab \strong{DEFAULT} \tab \strong{REMARKS} \cr
\code{variable.names_IAM} \tab \link{character} \tab \code{c('A', 'a', 'sig_a')} \tab variables names to be monitored in the modelling process using the internal function \code{.calc_IndividualAgeModel()}\cr
\code{variable.names_BCAM} \tab \link{character} \tab \code{c('A', 'D_e')} \tab variables names to be monitored in the modelling process using the internal function \code{.calc_BayesianCentraAgelModel()}\cr
\code{n.chains} \tab \link{integer} \tab \code{4} \tab number of MCMC chains\cr
\code{n.adapt} \tab \link{integer} \tab \code{1000} \tab number of iterations for the adaptation\cr
\code{n.iter} \tab \link{integer} \tab \code{5000} \tab number of iterations to monitor cf. \link[rjags:coda.samples]{rjags::coda.samples}\cr
\code{thin} \tab \link{numeric} \tab \code{1} \tab thinning interval for the monitoring cf. \link[rjags:coda.samples]{rjags::coda.samples}\cr
\code{diag} \tab \link{logical} \tab \code{FALSE} \tab additional terminal convergence diagnostic.
\code{FALSE} if \code{verbose = FALSE}\cr
\code{progress.bar} \tab \link{logical} \tab \code{FALSE} \tab enable/disable progress bar. \code{FALSE} if \code{verbose = FALSE}\cr
\code{quiet} \tab \link{logical} \tab \code{TRUE} \tab silence terminal output. Set to \code{TRUE} if \code{verbose = FALSE}\cr
\code{return_mcmc}\tab \link{logical} \tab \code{FALSE} \tab return additional MCMC diagnostic information\cr
}
}
\section{Function version}{
 0.1.0
}

\examples{
## set parameters
Dr <- stats::rlnorm (1000, 0, 0.3)
De <- 50*sample(Dr, 50, replace = TRUE)
s <- stats::rnorm(50, 10, 2)

## run modelling
## note: modify parameters for more realistic results
\dontrun{
results <- combine_De_Dr(
 Dr = Dr,
 int_OD = 0.1,
 De,
 s,
 Age_range = c(0,100),
 method_control = list(
  n.iter = 100,
  n.chains = 1))

## show models used
writeLines(results@info$model_IAM)
writeLines(results@info$model_BCAM)
}

} 

\section{How to cite}{
Philippe, A., Galharret, J., Mercier, N., Kreutzer, S., 2022. combine_De_Dr(): Combine Dose Rate and Equivalent Dose Distribution. Function version 0.1.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., 2022. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.19. https://CRAN.R-project.org/package=Luminescence
}

\references{
Mercier, N., Galharret, J.-M., Tribolo, C., Kreutzer, S., Philippe, A., preprint.
Luminescence age calculation through Bayesian convolution of equivalent dose and
dose-rate distributions: the De_Dr model. Geochronology, 1-22.

Galharret, J-M., Philippe, A., Mercier, N., preprint. Detection of outliers with
a Bayesian hierarchical model: application to the single-grain luminescence dating method.
Electronic Journal of Applied Statistics

\strong{Further reading}

Rousseeuw, P.J., Croux, C., 1993. Alternatives to the median absolute deviation.
Journal of the American Statistical Association 88, 1273–1283. \doi{10.2307/2291267}

Rousseeuw, P.J., Debruyne, M., Engelen, S., Hubert, M., 2006. Robustness and outlier detection in chemometrics.
Critical Reviews in Analytical Chemistry 36, 221–242. \doi{10.1080/10408340600969403}
}
\seealso{
\link{plot_OSLAgeSummary}, \link[rjags:rjags-package]{rjags::rjags}, \link{mclust-package}
}
\author{
Anne Philippe, Université de Nantes (France),
Jean-Michel Galharret, Université de Nantes (France),
Norbert Mercier, IRAMAT-CRP2A, Université Bordeaux Montaigne (France),
Sebastian Kreutzer, Geography & Earth Sciences, Aberystwyth University (United Kingdom)
, RLum Developer Team}
\keyword{datagen}
\keyword{distribution}
\keyword{dplot}
