/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.seeding;

import uk.ac.rhul.cs.cl1.MutableNodeSet;
import uk.ac.rhul.cs.cl1.seeding.SeedGenerator;
import uk.ac.rhul.cs.cl1.seeding.SeedIterator;
import uk.ac.rhul.cs.graph.Graph;

public class EveryNodeSeedGenerator
extends SeedGenerator {
    public EveryNodeSeedGenerator() {
    }

    public EveryNodeSeedGenerator(Graph graph) {
        super(graph);
    }

    public SeedIterator iterator() {
        return new IteratorImpl();
    }

    public int size() {
        return this.graph.getNodeCount();
    }

    private class IteratorImpl
    extends SeedIterator {
        private int i;
        private int n;

        IteratorImpl() {
            this.n = EveryNodeSeedGenerator.this.graph.getNodeCount();
            this.i = 0;
        }

        public double getPercentCompleted() {
            return 100.0 * (double)this.i / (double)this.n;
        }

        public boolean hasNext() {
            return this.i < this.n;
        }

        public MutableNodeSet next() {
            MutableNodeSet result = new MutableNodeSet(EveryNodeSeedGenerator.this.graph);
            result.add(this.i);
            ++this.i;
            return result;
        }
    }
}

