/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui.cytoscape3;

import java.awt.Color;
import java.awt.Paint;
import java.util.List;
import java.util.Set;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.presentation.property.NodeShapeVisualProperty;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.VisualStyleFactory;
import org.cytoscape.view.vizmap.mappings.BoundaryRangeValues;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;
import org.cytoscape.view.vizmap.mappings.DiscreteMapping;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.ClusterONECytoscapeApp;

public class VisualStyleManager {
    public static final String VISUAL_STYLE_BY_STATUS = "ClusterONE - Status";
    public static final String VISUAL_STYLE_BY_AFFINITY = "ClusterONE - Affinity";
    private ClusterONECytoscapeApp app;
    private ContinuousMapping<Double, Paint> affinityColorMapping;
    private VisualStyle colorNodesByAffinityVisualStyle;
    private VisualStyle colorNodesByStatusVisualStyle;

    public VisualStyleManager(ClusterONECytoscapeApp app) {
        this.app = app;
    }

    public void ensureVizMapperStylesRegistered() {
        VisualMappingManager visualMappingManager = this.app.getService(VisualMappingManager.class);
        if (visualMappingManager == null) {
            return;
        }
        this.ensureVisualStyleRegistered(visualMappingManager, this.getColorNodesByStatusVisualStyle());
        this.ensureVisualStyleRegistered(visualMappingManager, this.getColorNodesByAffinityVisualStyle());
    }

    private void ensureVisualStyleRegistered(VisualMappingManager manager, VisualStyle style) {
        if (style == null) {
            return;
        }
        Set styles = manager.getAllVisualStyles();
        if (styles.contains(style)) {
            return;
        }
        manager.addVisualStyle(style);
    }

    public VisualStyle getColorNodesByStatusVisualStyle() {
        if (this.colorNodesByStatusVisualStyle == null) {
            VisualStyleFactory factory = this.app.getService(VisualStyleFactory.class);
            VisualMappingFunctionFactory discreteMappingFactory = this.app.getService(VisualMappingFunctionFactory.class, "(mapping.type=discrete)");
            if (factory != null && discreteMappingFactory != null) {
                this.colorNodesByStatusVisualStyle = factory.createVisualStyle(VISUAL_STYLE_BY_STATUS);
                DiscreteMapping colorMapping = (DiscreteMapping)discreteMappingFactory.createVisualMappingFunction("cl1.Status", String.class, BasicVisualLexicon.NODE_FILL_COLOR);
                colorMapping.putMapValue((Object)"Outlier", (Object)Color.LIGHT_GRAY);
                colorMapping.putMapValue((Object)"Cluster", (Object)Color.RED);
                colorMapping.putMapValue((Object)"Overlap", (Object)Color.ORANGE);
                this.colorNodesByStatusVisualStyle.addVisualMappingFunction((VisualMappingFunction)colorMapping);
                DiscreteMapping shapeMapping = (DiscreteMapping)discreteMappingFactory.createVisualMappingFunction("cl1.Status", String.class, BasicVisualLexicon.NODE_SHAPE);
                shapeMapping.putMapValue((Object)"Outlier", (Object)NodeShapeVisualProperty.ELLIPSE);
                shapeMapping.putMapValue((Object)"Cluster", (Object)NodeShapeVisualProperty.RECTANGLE);
                shapeMapping.putMapValue((Object)"Overlap", (Object)NodeShapeVisualProperty.DIAMOND);
                this.colorNodesByStatusVisualStyle.addVisualMappingFunction((VisualMappingFunction)shapeMapping);
            }
        }
        return this.colorNodesByStatusVisualStyle;
    }

    public VisualStyle getColorNodesByAffinityVisualStyle() {
        if (this.colorNodesByAffinityVisualStyle == null) {
            VisualStyleFactory factory = this.app.getService(VisualStyleFactory.class);
            VisualMappingFunctionFactory discreteMappingFactory = this.app.getService(VisualMappingFunctionFactory.class, "(mapping.type=discrete)");
            VisualMappingFunctionFactory continuousMappingFactory = this.app.getService(VisualMappingFunctionFactory.class, "(mapping.type=continuous)");
            if (factory != null && discreteMappingFactory != null && continuousMappingFactory != null) {
                this.colorNodesByAffinityVisualStyle = factory.createVisualStyle(VISUAL_STYLE_BY_AFFINITY);
                this.affinityColorMapping = (ContinuousMapping)continuousMappingFactory.createVisualMappingFunction("cl1.Affinity", Double.class, BasicVisualLexicon.NODE_FILL_COLOR);
                this.updateAffinityStyleRange(null);
                this.colorNodesByAffinityVisualStyle.addVisualMappingFunction(this.affinityColorMapping);
                DiscreteMapping shapeMapping = (DiscreteMapping)discreteMappingFactory.createVisualMappingFunction("cl1.Status", String.class, BasicVisualLexicon.NODE_SHAPE);
                shapeMapping.putMapValue((Object)"Outlier", (Object)NodeShapeVisualProperty.ELLIPSE);
                shapeMapping.putMapValue((Object)"Cluster", (Object)NodeShapeVisualProperty.RECTANGLE);
                shapeMapping.putMapValue((Object)"Overlap", (Object)NodeShapeVisualProperty.DIAMOND);
                this.colorNodesByAffinityVisualStyle.addVisualMappingFunction((VisualMappingFunction)shapeMapping);
            }
        }
        return this.colorNodesByAffinityVisualStyle;
    }

    public void updateAffinityStyleRange(CyNetwork network) {
        double range = 0.1;
        Color minColor = Color.blue;
        Color midColor = Color.white;
        Color maxColor = Color.red;
        if (network != null) {
            List scores = network.getDefaultNodeTable().getColumn("cl1.Affinity").getValues(Double.class);
            for (Double score : scores) {
                if (!(Math.abs(score) > range)) continue;
                range = Math.abs(score);
            }
        }
        int n = this.affinityColorMapping.getPointCount();
        while (n > 0) {
            this.affinityColorMapping.removePoint(--n);
        }
        this.affinityColorMapping.addPoint((Object)(-range), new BoundaryRangeValues((Object)minColor, (Object)minColor, (Object)minColor));
        this.affinityColorMapping.addPoint((Object)0.0, new BoundaryRangeValues((Object)midColor, (Object)midColor, (Object)midColor));
        this.affinityColorMapping.addPoint((Object)range, new BoundaryRangeValues((Object)maxColor, (Object)maxColor, (Object)maxColor));
    }
}

