/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import uk.ac.rhul.cs.graph.Directedness;
import uk.ac.rhul.cs.graph.Graph;
import uk.ac.rhul.cs.graph.GraphAlgorithm;
import uk.ac.rhul.cs.utils.IntegerRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BronKerboschMaximalCliqueFinder
extends GraphAlgorithm {
    protected void findCliques(Collection<List<Integer>> result, HashSet<Integer> potentialClique, HashSet<Integer> candidates, HashSet<Integer> alreadyFound) {
        if (this.isAnyConnectedToAllCandidates(alreadyFound, candidates)) {
            return;
        }
        Graph graph = this.getGraph();
        Iterator<Integer> it = candidates.iterator();
        while (it.hasNext()) {
            int[] neis;
            Integer candidate = it.next();
            HashSet<Integer> newCandidates = new HashSet<Integer>();
            HashSet<Integer> newAlreadyFound = new HashSet<Integer>();
            potentialClique.add(candidate);
            it.remove();
            for (int nei : neis = graph.getAdjacentNodeIndicesArray(candidate, Directedness.ALL)) {
                if (candidates.contains(nei)) {
                    newCandidates.add(nei);
                }
                if (!alreadyFound.contains(nei)) continue;
                newAlreadyFound.add(nei);
            }
            if (newCandidates.isEmpty() && newAlreadyFound.isEmpty()) {
                result.add(new ArrayList<Integer>(potentialClique));
            } else {
                this.findCliques(result, potentialClique, newCandidates, newAlreadyFound);
            }
            alreadyFound.add(candidate);
            potentialClique.remove(candidate);
        }
    }

    public List<List<Integer>> getMaximalCliques() {
        ArrayList<List<Integer>> result = new ArrayList<List<Integer>>();
        this.getMaximalCliques(result);
        return result;
    }

    public void getMaximalCliques(Collection<List<Integer>> result) {
        HashSet<Integer> potentialClique = new HashSet<Integer>();
        HashSet<Integer> candidates = new HashSet<Integer>();
        HashSet<Integer> alreadyFound = new HashSet<Integer>();
        candidates.addAll(new IntegerRange(this.graph.getNodeCount()));
        this.findCliques(result, potentialClique, candidates, alreadyFound);
    }

    protected boolean isAnyConnectedToAllCandidates(HashSet<Integer> nodes, HashSet<Integer> candidates) {
        Graph graph = this.getGraph();
        HashSet<Integer> neiSet = new HashSet<Integer>();
        for (int node : nodes) {
            int[] neis = graph.getAdjacentNodeIndicesArray(node, Directedness.ALL);
            if (neis.length < candidates.size()) continue;
            neiSet.clear();
            for (int nei : neis) {
                neiSet.add(nei);
            }
            if (neiSet.size() < candidates.size()) continue;
            neiSet.retainAll(candidates);
            if (neiSet.size() != candidates.size()) continue;
            return true;
        }
        return false;
    }
}

