% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_MissingData.R
\name{impute_MissingData}
\alias{impute_MissingData}
\title{Impute missing Values in Elution Profile Matrix}
\usage{
impute_MissingData(x)
}
\arguments{
\item{x}{A data matrix with rows
including proteins and fractions along the columns, while some
fractions may contain missing values.}
}
\value{
Imputed matrix.
}
\description{
This function imputes missing values in protein elution
profile matrix via average of adjacent rows. This function is
not applicable for missing values present in the first or last column.
}
\details{
impute_MissingData
}
\examples{
# Load the co-elution data
data("exampleData")
# Replace the values with NAs in the 10th column
exampleData[, 10] <- NA
# Impute missing value
datOut <- impute_MissingData(exampleData)
}
\author{
Matineh Rahmatbakhsh, \email{matinerb.94@gmail.com}
}
