% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Density_overlap.R
\name{Density_overlap}
\alias{Density_overlap}
\title{Density_overlap}
\usage{
Density_overlap(
  Data,
  variable,
  group,
  variable_name = NULL,
  group_labels = NULL,
  group_name = NULL,
  step_num = NULL,
  step_var = NULL,
  verbose = TRUE
)
}
\arguments{
\item{Data}{A data frame that contains the desired variable for density
plotting as well as the specified grouping variable.}

\item{variable}{A character specifying the variable for which the density
should be plotted (e.g., "ps_gifted").}

\item{group}{A character specifying the groups for which the density should
be plotted. Can be an independent group comparison (e.g., comparing matched
groups) or the comparison of pre and post matched samples.}

\item{variable_name}{A character specifying the name to appear
in the plot for the variable.}

\item{group_labels}{A character vector specifying the labels for the groups
to ppear in the legend of the plot.}

\item{group_name}{A character specifying the name of the grouping variable
to appear in the title of the legend.}

\item{step_num}{An integer specifying the number of cases to be included
per group in this post matching comparison. Is based on the step variable of
MAGMA.}

\item{step_var}{A character specifying the name of the step variable.}

\item{verbose}{TRUE or FALSE indicating whether matching information should
be printed to the console.}
}
\value{
A plot showing the kernel density for a specified variable separately
for specified groups and the quantification of this overlap.
}
\description{
This function shows and quantifies the kernel density overlap of a variable
for two or more groups.
}
\details{
This function enables the comparison of the density of variables for two
or more groups. It plots the kernel density separately for each group and
quantifies the amount of overlap.
}
\examples{
# Estimating density overlap using the data set 'MAGMA_sim_data
# Estimating density overlap for 'ps_gifted' (propensity scores for
# giftedness support)
# Defining plot aesthetics with 'group', 'variable_name', "group_lables',
# and 'group_name'
# Estimating pre-matching density overlap by not specifying 'step_num' and
# 'step_var'
Density_overlap(Data = MAGMA_sim_data,
variable = "ps_gifted",
group = "gifted_support",
step_num = NULL,
step_var = NULL,
variable_name = "Propensity Score",
group_labels = c("No Support", "Support"),
group_name = "Gifted Support")


# Estimating density overlap using the matched data set
#'MAGMA_sim_data_gifted'
# Estimating density overlap for 'ps_gifted' (propensity scores for
# giftedness support)
# Defining plot aesthetics with 'group', 'variable_name', 'group_lables',
# and 'group_name'
# Estimating post-matching overlap for 250 cases per group ('step_num')
# Name of the step variable is 'step'
Density_overlap(Data = MAGMA_sim_data,
variable = "ps_gifted",
group = "gifted_support",
step_num = 250,
step_var = "step_gifted",
variable_name = "Propensity Score",
group_labels = c("No Support", "Support"),
group_name = "Gifted Support")

# Estimating density overlap using the data set 'MAGMA_sim_data
# Estimating density overlap for 'teacher_ability_rating' (ability rated
# from teacher as below average, average, or above average)
# Defining plot aesthetics with 'group', 'variable_name', 'group_lables',
# and 'group_name'
# Estimating pre-matching density overlap by not specifying 'step_num' and
# 'step_var'
Density_overlap(Data = MAGMA_sim_data,
variable = "GPA_school",
group = "teacher_ability_rating",
variable_name = "School Achievement",
group_labels = c("Low", "Medium", "High"),
group_name = "Rating")

}
\references{
{Pastore, M., Loro, P.A.D., Mingione, M., Calcagni, A. (2022). \emph{overlapping: Estimation of Overlapping in Empirical Distributions}. R package version
2.1, \url{https://CRAN.R-project.org/package=overlapping}.}
}
\author{
Julian Urban
}
