\name{importCiphergenXml}
\alias{importCiphergenXml}
\title{Import Ciphergen XML files}
\usage{
  importCiphergenXml(path, verbose = FALSE)
}
\arguments{
  \item{path}{\code{character}, path to directory or file
  which should be read in.}

  \item{verbose}{\code{logical}, verbose output?}
}
\value{
  a \code{list} of
  \code{\link[MALDIquant]{MassSpectrum-class}} objects.
}
\description{
  This function imports files in Ciphergen XML file format
  into \code{\link[MALDIquant]{MassSpectrum-class}}
  objects.
}
\examples{
library("MALDIquant")
library("MALDIquantForeign")

## get example directory
exampleDirectory <- system.file(file.path("tests", "data"),
                                package="MALDIquantForeign")

## import
s <- importCiphergenXml(exampleDirectory)
}
\author{
  Sebastian Gibb
}
\references{
  \url{http://strimmerlab.org/software/maldiquant/}
}
\seealso{
  \code{\link[MALDIquant]{MassSpectrum-class}}
}

