% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MANOVA_simCI.R
\name{simCI}
\alias{simCI}
\title{Simultaneous confidence intervals for contrasts in multivariate factorial designs.}
\usage{
simCI(object, contrast = c("pairwise", "user-defined"), contmat = NULL,
  type = NULL, base = 1, ...)
}
\arguments{
\item{object}{A \code{MANOVA} object.}

\item{contrast}{The contrast matrix of interest, can either be "pairwise" or "user-defined".}

\item{contmat}{If contrast = "user-defined", the contrast matrix must be specified here. Note that
its rows must sum to zero.}

\item{type}{If contrast is "pairwise", the type of the pairwise comparison must be specified here. 
Calculation is based on the contrMat function in package multcomp, see the corresponding help page 
for details on the types of contrasts available.}

\item{base}{an interger specifying which group is considered the baseline group 
for Dunnett contrasts, see \code{\link[multcomp]{contrMat}}.}

\item{...}{Not used yet.}
}
\value{
Simultaneous confidence intervals for the chosen contrasts.
}
\description{
Simultaneous confidence intervals for contrasts in multivariate factorial designs.
}
\details{
The simCI() function computes confidence intervals for the chosen contrasts of the multivariate mean vector 
based on the sum statistic. Details on the derivation of these confidence intervals can be found in Friedrich and Pauly (2018).
}
\references{
Friedrich, S., and Pauly, M. (2018). MATS: Inference for potentially singular and
  heteroscedastic MANOVA. Journal of Multivariate Analysis, 165, 166-179.
}
\seealso{
\code{\link[multcomp]{contrMat}}
}
