% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_PLATE_08_DE_4_ModalityChange.R
\name{ModalityChange}
\alias{ModalityChange}
\title{Classify modality changes}
\usage{
ModalityChange(MarvelObject, method, psi.pval, psi.delta = 0)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{CompareValues} function.}

\item{method}{Character string. The statistical method used for differential splicing analysis.}

\item{psi.pval}{Numeric value. Adjusted p-value below which the splicing event is considered differentially spliced and included for modality analysis.}

\item{psi.delta}{Numeric value. The absolute difference between the means PSI values of cell group 1 and 2, above which, the splicing event is considered differentially spliced and included for modality analysis.}
}
\value{
An object of class S3 with new slots \code{MarvelObject$DE$Modality$Table}, \code{MarvelObject$DE$Modality$Plot}, and \code{MarvelObject$DE$Modality$Plot.Stats}.
}
\description{
Classifies the type of modality change for each splicing event that has taken place between 2 groups of cells.
}
\examples{
marvel.demo <- readRDS(system.file("extdata/data", "marvel.demo.rds", package="MARVEL"))

marvel.demo <- ModalityChange(MarvelObject=marvel.demo,
                              method="ad",
                              psi.pval=0.1,
                              psi.delta=0
                              )

# Check outputs
head(marvel.demo$DE$Modality$Table)
marvel.demo$DE$Modality$Plot
marvel.demo$DE$Modality$Plot.Stats
}
